/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.converters;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.datanucleus.store.types.converters.TypeConverter;

public class LocalDateSqlDateConverter
implements TypeConverter<LocalDate, java.sql.Date> {
    private static final long serialVersionUID = -4923966747560026044L;

    @Override
    public LocalDate toMemberType(java.sql.Date date) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), ZoneId.systemDefault()).toLocalDate();
    }

    @Override
    public java.sql.Date toDatastoreType(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return new java.sql.Date(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()).getTime());
    }
}

