/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import java.util.List;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;

public class BinaryOperatorConversion
implements DruidSqlOperatorConverter {
    private final SqlOperator operator;
    private final String druidOperator;

    public BinaryOperatorConversion(SqlOperator operator, String druidOperator) {
        this.operator = operator;
        this.druidOperator = druidOperator;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        RexCall call = (RexCall)rexNode;
        List<String> druidExpressions = DruidExpressions.toDruidExpressions(druidQuery, rowType, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        if (druidExpressions.size() != 2) {
            throw new IllegalStateException(DruidQuery.format("Got binary operator[%s] with %s args?", this.operator.getName(), druidExpressions.size()));
        }
        return DruidQuery.format("(%s %s %s)", druidExpressions.get(0), this.druidOperator, druidExpressions.get(1));
    }
}

