/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.common.JvmMetricsInfo;
import org.apache.hadoop.hive.common.JvmPauseMonitor;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;

public class JvmMetrics
implements MetricsSource {
    static final float M = 1048576.0f;
    final MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    final String processName;
    final String sessionId;
    private JvmPauseMonitor pauseMonitor = null;
    final ConcurrentHashMap<String, MetricsInfo[]> gcInfoCache = new ConcurrentHashMap();

    JvmMetrics(String processName, String sessionId) {
        this.processName = processName;
        this.sessionId = sessionId;
    }

    public void setPauseMonitor(JvmPauseMonitor pauseMonitor) {
        this.pauseMonitor = pauseMonitor;
    }

    public static JvmMetrics create(String processName, String sessionId, MetricsSystem ms) {
        return (JvmMetrics)ms.register(JvmMetricsInfo.JvmMetrics.name(), JvmMetricsInfo.JvmMetrics.description(), (Object)new JvmMetrics(processName, sessionId));
    }

    public static JvmMetrics initSingleton(String processName, String sessionId) {
        return Singleton.INSTANCE.init(processName, sessionId);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)JvmMetricsInfo.JvmMetrics).setContext("jvm").tag((MetricsInfo)MsInfo.ProcessName, this.processName).tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getMemoryUsage(rb);
        this.getGcUsage(rb);
        this.getThreadUsage(rb);
    }

    private void getMemoryUsage(MetricsRecordBuilder rb) {
        MemoryUsage memNonHeap = this.memoryMXBean.getNonHeapMemoryUsage();
        MemoryUsage memHeap = this.memoryMXBean.getHeapMemoryUsage();
        Runtime runtime = Runtime.getRuntime();
        rb.addGauge((MetricsInfo)JvmMetricsInfo.MemNonHeapUsedM, (float)memNonHeap.getUsed() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemNonHeapCommittedM, (float)memNonHeap.getCommitted() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemNonHeapMaxM, (float)memNonHeap.getMax() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemHeapUsedM, (float)memHeap.getUsed() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemHeapCommittedM, (float)memHeap.getCommitted() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemHeapMaxM, (float)memHeap.getMax() / 1048576.0f).addGauge((MetricsInfo)JvmMetricsInfo.MemMaxM, (float)runtime.maxMemory() / 1048576.0f);
    }

    private void getGcUsage(MetricsRecordBuilder rb) {
        long count = 0L;
        long timeMillis = 0L;
        for (GarbageCollectorMXBean gcBean : this.gcBeans) {
            long c = gcBean.getCollectionCount();
            long t = gcBean.getCollectionTime();
            MetricsInfo[] gcInfo = this.getGcInfo(gcBean.getName());
            rb.addCounter(gcInfo[0], c).addCounter(gcInfo[1], t);
            count += c;
            timeMillis += t;
        }
        rb.addCounter((MetricsInfo)JvmMetricsInfo.GcCount, count).addCounter((MetricsInfo)JvmMetricsInfo.GcTimeMillis, timeMillis);
        if (this.pauseMonitor != null) {
            rb.addCounter((MetricsInfo)JvmMetricsInfo.GcNumWarnThresholdExceeded, this.pauseMonitor.getNumGcWarnThresholdExceeded());
            rb.addCounter((MetricsInfo)JvmMetricsInfo.GcNumInfoThresholdExceeded, this.pauseMonitor.getNumGcInfoThresholdExceeded());
            rb.addCounter((MetricsInfo)JvmMetricsInfo.GcTotalExtraSleepTime, this.pauseMonitor.getTotalGcExtraSleepTime());
        }
    }

    private MetricsInfo[] getGcInfo(String gcName) {
        MetricsInfo[] gcInfo = this.gcInfoCache.get(gcName);
        if (gcInfo == null) {
            gcInfo = new MetricsInfo[]{Interns.info((String)("GcCount" + gcName), (String)("GC Count for " + gcName)), Interns.info((String)("GcTimeMillis" + gcName), (String)("GC Time for " + gcName))};
            MetricsInfo[] previousGcInfo = this.gcInfoCache.putIfAbsent(gcName, gcInfo);
            if (previousGcInfo != null) {
                return previousGcInfo;
            }
        }
        return gcInfo;
    }

    private void getThreadUsage(MetricsRecordBuilder rb) {
        ThreadCountResult result = JvmMetrics.getThreadCountResult(this.threadMXBean);
        rb.addGauge((MetricsInfo)JvmMetricsInfo.ThreadsNew, result.threadsNew).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsRunnable, result.threadsRunnable).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsBlocked, result.threadsBlocked).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsWaiting, result.threadsWaiting).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsTimedWaiting, result.threadsTimedWaiting).addGauge((MetricsInfo)JvmMetricsInfo.ThreadsTerminated, result.threadsTerminated);
    }

    public static ThreadCountResult getThreadCountResult(ThreadMXBean threadMXBean) {
        int threadsNew = 0;
        int threadsRunnable = 0;
        int threadsBlocked = 0;
        int threadsWaiting = 0;
        int threadsTimedWaiting = 0;
        int threadsTerminated = 0;
        long[] threadIds = threadMXBean.getAllThreadIds();
        block8: for (ThreadInfo threadInfo : threadMXBean.getThreadInfo(threadIds, 0)) {
            if (threadInfo == null) continue;
            switch (threadInfo.getThreadState()) {
                case NEW: {
                    ++threadsNew;
                    continue block8;
                }
                case RUNNABLE: {
                    ++threadsRunnable;
                    continue block8;
                }
                case BLOCKED: {
                    ++threadsBlocked;
                    continue block8;
                }
                case WAITING: {
                    ++threadsWaiting;
                    continue block8;
                }
                case TIMED_WAITING: {
                    ++threadsTimedWaiting;
                    continue block8;
                }
                case TERMINATED: {
                    ++threadsTerminated;
                }
            }
        }
        return new ThreadCountResult(threadsNew, threadsRunnable, threadsBlocked, threadsWaiting, threadsTimedWaiting, threadsTerminated);
    }

    static enum Singleton {
        INSTANCE;

        JvmMetrics impl;

        synchronized JvmMetrics init(String processName, String sessionId) {
            if (this.impl == null) {
                this.impl = JvmMetrics.create(processName, sessionId, DefaultMetricsSystem.instance());
            }
            return this.impl;
        }
    }

    public static class ThreadCountResult {
        public final int threadsNew;
        public final int threadsRunnable;
        public final int threadsBlocked;
        public final int threadsWaiting;
        public final int threadsTimedWaiting;
        public final int threadsTerminated;

        public ThreadCountResult(int threadsNew, int threadsRunnable, int threadsBlocked, int threadsWaiting, int threadsTimedWaiting, int threadsTerminated) {
            this.threadsNew = threadsNew;
            this.threadsRunnable = threadsRunnable;
            this.threadsBlocked = threadsBlocked;
            this.threadsWaiting = threadsWaiting;
            this.threadsTimedWaiting = threadsTimedWaiting;
            this.threadsTerminated = threadsTerminated;
        }
    }
}

