/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.rcfile.truncate;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.TaskQueue;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.mr.Throttle;
import org.apache.hadoop.hive.ql.io.BucketizedHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateMapper;
import org.apache.hadoop.hive.ql.io.rcfile.truncate.ColumnTruncateWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class ColumnTruncateTask
extends Task<ColumnTruncateWork>
implements Serializable,
HadoopJobExecHook {
    private static final long serialVersionUID = 1L;
    protected transient JobConf job;
    protected HadoopJobExecHelper jobExecHelper;
    boolean success = true;

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, TaskQueue taskQueue, Context context) {
        super.initialize(queryState, queryPlan, taskQueue, context);
        this.job = new JobConf((Configuration)this.conf, ColumnTruncateTask.class);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute() {
        HiveConf.setVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_INPUT_FORMAT, (String)BucketizedHiveInputFormat.class.getName());
        this.success = true;
        HiveFileFormatUtils.prepareJobOutput(this.job);
        this.job.setOutputFormat(HiveOutputFormatImpl.class);
        this.job.setMapperClass(((ColumnTruncateWork)this.work).getMapperClass());
        Context ctx = this.context;
        boolean ctxCreated = false;
        if (ctx == null) {
            ctx = new Context((Configuration)this.job);
            ctxCreated = true;
        }
        this.job.setMapOutputKeyClass(NullWritable.class);
        this.job.setMapOutputValueClass(NullWritable.class);
        if (((ColumnTruncateWork)this.work).getNumMapTasks() != null) {
            this.job.setNumMapTasks(((ColumnTruncateWork)this.work).getNumMapTasks().intValue());
        }
        this.job.setNumReduceTasks(0);
        this.job.setBoolean("mapreduce.reduce.speculative", false);
        this.job.setBoolean("mapreduce.map.speculative", false);
        if (((ColumnTruncateWork)this.work).getMinSplitSize() != null) {
            HiveConf.setLongVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.MAPRED_MIN_SPLIT_SIZE, (long)((ColumnTruncateWork)this.work).getMinSplitSize());
        }
        if (((ColumnTruncateWork)this.work).getInputformat() != null) {
            HiveConf.setVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_INPUT_FORMAT, (String)((ColumnTruncateWork)this.work).getInputformat());
        }
        String inpFormat = HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_INPUT_FORMAT);
        LOG.info("Using " + inpFormat);
        try {
            this.job.setInputFormat(JavaUtils.loadClass((String)inpFormat));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        Path outputPath = ((ColumnTruncateWork)this.work).getOutputDir();
        Path tempOutPath = Utilities.toTempPath(outputPath);
        try {
            FileSystem fs = tempOutPath.getFileSystem((Configuration)this.job);
            if (!fs.exists(tempOutPath)) {
                fs.mkdirs(tempOutPath);
            }
        }
        catch (IOException e) {
            this.setException(e);
            LOG.error("Can't make path " + String.valueOf(outputPath), (Throwable)e);
            return 6;
        }
        this.job.setOutputKeyClass(NullWritable.class);
        this.job.setOutputValueClass(NullWritable.class);
        int returnVal = 0;
        RunningJob rj = null;
        boolean noName = StringUtils.isEmpty((CharSequence)this.job.get("mapreduce.job.name"));
        Object jobName = null;
        if (noName && this.getQueryPlan() != null) {
            int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVE_JOBNAME_LENGTH);
            jobName = Utilities.abbreviate(this.getQueryPlan().getQueryStr(), maxlen - 6);
        }
        if (noName) {
            this.job.set("mapreduce.job.name", jobName != null ? jobName : "JOB" + ThreadLocalRandom.current().nextInt());
        }
        try {
            this.addInputPaths(this.job, (ColumnTruncateWork)this.work);
            MapredWork mrWork = new MapredWork();
            mrWork.setMapWork((MapWork)this.work);
            Utilities.setMapRedWork((Configuration)this.job, mrWork, ctx.getMRTmpPath());
            String pwd = HiveConf.getVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_PWD);
            if (pwd != null) {
                HiveConf.setVar((Configuration)this.job, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_PWD, (String)"HIVE");
            }
            JobClient jc = new JobClient(this.job);
            String addedJars = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.JAR);
            if (!addedJars.isEmpty()) {
                this.job.set("tmpjars", addedJars);
            }
            Throttle.checkJobTracker(this.job, LOG);
            rj = jc.submitJob(this.job);
            this.jobID = rj.getJobID();
            returnVal = this.jobExecHelper.progress(rj, jc, ctx);
            this.success = returnVal == 0;
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (rj != null && returnVal != 0) {
                    rj.killJob();
                }
                ColumnTruncateMapper.jobClose(outputPath, this.success, this.job, this.console, ((ColumnTruncateWork)this.work).getDynPartCtx(), null);
                return returnVal;
            }
            catch (Exception e) {
                LOG.warn("Failed while cleaning up ", (Throwable)e);
                return returnVal;
            }
            finally {
                HadoopJobExecHelper.runningJobs.remove(rj);
            }
        }
        catch (Exception e) {
            String mesg = rj != null ? "Ended Job = " + rj.getJobID() : "Job Submission failed";
            LOG.error(mesg, (Throwable)e);
            this.setException(e);
            this.success = false;
            returnVal = 1;
            return returnVal;
        }
        finally {
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (rj != null && returnVal != 0) {
                    rj.killJob();
                }
                ColumnTruncateMapper.jobClose(outputPath, this.success, this.job, this.console, ((ColumnTruncateWork)this.work).getDynPartCtx(), null);
            }
            catch (Exception e) {
                LOG.warn("Failed while cleaning up ", (Throwable)e);
            }
            finally {
                HadoopJobExecHelper.runningJobs.remove(rj);
            }
        }
    }

    private void addInputPaths(JobConf job, ColumnTruncateWork work) {
        FileInputFormat.addInputPath((JobConf)job, (Path)work.getInputDir());
    }

    public String getName() {
        return "RCFile ColumnTruncate";
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        return false;
    }

    @Override
    public void logPlanProgress(SessionState ss) throws IOException {
    }
}

