/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.ColumnPropagationException;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.InputRefShifter;

public class HiveRowIsDeletedPropagator
implements ReflectiveVisitor {
    private static final String ANY_DELETED_COLUMN_NAME = "_any_deleted";
    private static final String ANY_INSERTED_COLUMN_NAME = "_any_inserted";
    private static final String DELETED_COLUMN_NAME = "_deleted";
    private static final String INSERTED_COLUMN_NAME = "_inserted";
    private final RelBuilder relBuilder;
    private final ReflectUtil.MethodDispatcher<RelNode> dispatcher;

    public HiveRowIsDeletedPropagator(RelBuilder relBuilder) {
        this.relBuilder = relBuilder;
        this.dispatcher = ReflectUtil.createMethodDispatcher(RelNode.class, (ReflectiveVisitor)this, (String)"visit", RelNode.class, (Class[])new Class[]{Context.class});
    }

    public RelNode propagate(RelNode relNode) {
        return (RelNode)this.dispatcher.invoke(new Object[]{relNode, new Context()});
    }

    private RelNode visitChild(RelNode parent, int i, RelNode child, Context context) {
        RelNode newRel = (RelNode)this.dispatcher.invoke(new Object[]{child, context});
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(parent.getInputs());
        newInputs.set(i, newRel);
        return parent.copy(parent.getTraitSet(), newInputs);
    }

    private RelNode visitChildren(RelNode rel, Context context) {
        for (Ord input : Ord.zip((List)rel.getInputs())) {
            rel = this.visitChild(rel, input.i, (RelNode)input.e, context);
        }
        return rel;
    }

    public RelNode visit(RelNode relNode, Context context) {
        return this.visitChildren(relNode, context);
    }

    public RelNode visit(HiveTableScan scan, Context context) {
        RelDataType tableRowType = scan.getTable().getRowType();
        RelDataTypeField rowIdField = this.getVirtualColumnField(tableRowType, VirtualColumn.ROWID, scan);
        RexNode rowIdPredicate = context.rowIdPredicates.get(rowIdField.getIndex());
        RelDataTypeField rowIsDeletedField = this.getVirtualColumnField(tableRowType, VirtualColumn.ROWISDELETED, scan);
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        ArrayList<RexNode> projects = new ArrayList<RexNode>(tableRowType.getFieldCount());
        ArrayList<String> projectNames = new ArrayList<String>(tableRowType.getFieldCount());
        this.populateProjects(rexBuilder, tableRowType, projects, projectNames);
        RexNode rowIsDeleted = (RexNode)projects.remove(rowIsDeletedField.getIndex());
        projects.add(rowIsDeleted);
        if (rowIdPredicate == null) {
            projects.add((RexNode)rexBuilder.makeLiteral(false));
            projects.add((RexNode)rexBuilder.makeLiteral(false));
        } else {
            projects.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{rowIsDeleted, rowIdPredicate}));
            projects.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{rowIsDeleted}), rowIdPredicate}));
        }
        String rowIsDeletedName = (String)projectNames.remove(rowIsDeletedField.getIndex());
        projectNames.add(rowIsDeletedName);
        projectNames.add(DELETED_COLUMN_NAME);
        projectNames.add(INSERTED_COLUMN_NAME);
        return this.relBuilder.push((RelNode)scan.setTableScanTrait(HiveTableScan.HiveTableScanTrait.FetchDeletedRows)).project(projects, projectNames).build();
    }

    public RelNode visit(HiveProject project, Context context) {
        RelNode newProject = this.visitChild(project, 0, project.getInput(), context);
        RelNode projectInput = newProject.getInput(0);
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>(project.getProjects().size() + 2);
        newProjects.addAll(project.getProjects());
        newProjects.add(this.createInputRef(projectInput, 2));
        newProjects.add(this.createInputRef(projectInput, 1));
        return this.relBuilder.push(projectInput).project(newProjects).build();
    }

    public RelNode visit(HiveFilter filter, Context context) {
        RexNode condition = filter.getCondition();
        RexInputRef rexInputRef = this.findPossibleRowIdRef(filter.getCondition());
        if (rexInputRef != null) {
            context.rowIdPredicates.put(rexInputRef.getIndex(), filter.getCondition());
            return this.visitChild(filter, 0, filter.getInput(0), context);
        }
        if (!condition.isA(SqlKind.OR)) {
            return this.visitChild(filter, 0, filter.getInput(0), context);
        }
        for (RexNode operand : ((RexCall)condition).operands) {
            RexInputRef inputRef = this.findPossibleRowIdRef(operand);
            if (inputRef == null) continue;
            context.rowIdPredicates.put(inputRef.getIndex(), operand);
        }
        return this.visitChild(filter, 0, filter.getInput(0), context);
    }

    private RexInputRef findPossibleRowIdRef(RexNode operand) {
        Set<RexInputRef> inputRefs = this.findRexInputRefs(operand);
        if (inputRefs.size() != 1) {
            return null;
        }
        return inputRefs.iterator().next();
    }

    public RelNode visit(HiveJoin join, Context context) {
        RelNode tmpJoin = this.visitChild(join, 0, join.getInput(0), context);
        RelNode newLeftInput = tmpJoin.getInput(0);
        RelDataType newLeftRowType = newLeftInput.getRowType();
        Context rightContext = new Context();
        int originalLeftFieldCount = join.getInput(0).getRowType().getFieldCount();
        for (Map.Entry<Integer, RexNode> entry : context.rowIdPredicates.entrySet()) {
            if (entry.getKey() <= originalLeftFieldCount) continue;
            rightContext.rowIdPredicates.put(entry.getKey() - originalLeftFieldCount, new InputRefShifter(originalLeftFieldCount, -originalLeftFieldCount, this.relBuilder).apply(entry.getValue()));
        }
        tmpJoin = this.visitChild(join, 1, join.getInput(1), rightContext);
        RelNode newRightInput = tmpJoin.getInput(1);
        RelDataType newRightRowType = newRightInput.getRowType();
        int rightAnyDeletedIndex = newRightRowType.getFieldCount() - 2;
        int rightAnyInsertedIndex = newRightRowType.getFieldCount() - 1;
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RexNode leftDeleted = this.createInputRef(newLeftInput, 2);
        RexNode leftInserted = this.createInputRef(newLeftInput, 1);
        RexInputRef rightDeleted = rexBuilder.makeInputRef(((RelDataTypeField)newRightRowType.getFieldList().get(rightAnyDeletedIndex)).getType(), newLeftRowType.getFieldCount() + rightAnyDeletedIndex);
        RexInputRef rightInserted = rexBuilder.makeInputRef(((RelDataTypeField)newRightRowType.getFieldList().get(rightAnyInsertedIndex)).getType(), newLeftRowType.getFieldCount() + rightAnyInsertedIndex);
        int newLeftFieldCount = newLeftRowType.getFieldCount() - 2;
        RexNode newJoinCondition = new InputRefShifter(newLeftFieldCount, 2, this.relBuilder).apply(join.getCondition());
        ArrayList<RexNode> projects = new ArrayList<RexNode>(newLeftFieldCount + newRightRowType.getFieldCount() + 1);
        ArrayList<String> projectNames = new ArrayList<String>(newLeftFieldCount + newRightRowType.getFieldCount() + 1);
        this.populateProjects(rexBuilder, newLeftRowType, 0, newLeftFieldCount, projects, projectNames);
        this.populateProjects(rexBuilder, newRightRowType, newLeftRowType.getFieldCount(), newRightRowType.getFieldCount() - 2, projects, projectNames);
        projects.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{leftDeleted, rightDeleted}));
        projects.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, new RexNode[]{leftInserted, rightInserted}));
        projectNames.add(ANY_DELETED_COLUMN_NAME);
        projectNames.add(ANY_INSERTED_COLUMN_NAME);
        int anyDeletedIndex = projects.size() - 2;
        int anyInsertedIndex = projects.size() - 1;
        RexInputRef anyDeleted = rexBuilder.makeInputRef(((RexNode)projects.get(anyDeletedIndex)).getType(), anyDeletedIndex);
        RexInputRef anyInserted = rexBuilder.makeInputRef(((RexNode)projects.get(anyInsertedIndex)).getType(), anyInsertedIndex);
        RexNode filterCondition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{RexUtil.composeConjunction((RexBuilder)rexBuilder, Arrays.asList(anyDeleted, anyInserted))});
        return this.relBuilder.push(newLeftInput).push(newRightInput).join(join.getJoinType(), newJoinCondition).project(projects, projectNames).filter(new RexNode[]{filterCondition}).build();
    }

    private RelDataTypeField getVirtualColumnField(RelDataType tableRowType, VirtualColumn virtualColumn, HiveTableScan scan) {
        RelDataTypeField field = tableRowType.getField(virtualColumn.getName(), false, false);
        if (field == null) {
            throw new ColumnPropagationException("TableScan " + String.valueOf(scan) + " row schema does not contain " + virtualColumn.getName() + " virtual column");
        }
        return field;
    }

    private void populateProjects(RexBuilder rexBuilder, RelDataType inputRowType, List<RexNode> projects, List<String> projectNames) {
        this.populateProjects(rexBuilder, inputRowType, 0, inputRowType.getFieldCount(), projects, projectNames);
    }

    private void populateProjects(RexBuilder rexBuilder, RelDataType inputRowType, int offset, int length, List<RexNode> projects, List<String> projectNames) {
        for (int i = 0; i < length; ++i) {
            RelDataTypeField relDataTypeField = (RelDataTypeField)inputRowType.getFieldList().get(i);
            projects.add((RexNode)rexBuilder.makeInputRef(relDataTypeField.getType(), offset + i));
            projectNames.add(relDataTypeField.getName());
        }
    }

    private RexNode createInputRef(RelNode relNode, int negativeOffset) {
        int index = relNode.getRowType().getFieldCount() - negativeOffset;
        return this.relBuilder.getRexBuilder().makeInputRef(((RelDataTypeField)relNode.getRowType().getFieldList().get(index)).getType(), index);
    }

    private Set<RexInputRef> findRexInputRefs(RexNode rexNode) {
        final HashSet<RexInputRef> rexTableInputRefs = new HashSet<RexInputRef>();
        RexVisitorImpl<RexInputRef> visitor = new RexVisitorImpl<RexInputRef>(this, true){

            public RexInputRef visitInputRef(RexInputRef inputRef) {
                rexTableInputRefs.add(inputRef);
                return (RexInputRef)super.visitInputRef(inputRef);
            }
        };
        rexNode.accept((RexVisitor)visitor);
        return rexTableInputRefs;
    }

    public static final class Context {
        private final Map<Integer, RexNode> rowIdPredicates = new HashMap<Integer, RexNode>();
    }
}

