/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.Callable;
import org.apache.thrift.TBase;

public class MetadataCache {
    private Cache<String, TBase> metaCache;

    public MetadataCache(boolean isCacheEnabled) {
        if (isCacheEnabled) {
            this.metaCache = Caffeine.newBuilder().softValues().maximumSize(10000L).build();
        }
    }

    public <T extends TBase<T, ?>> T computeIfAbsent(String key, Callable<T> callable) throws Exception {
        if (this.metaCache != null) {
            return (T)((TBase)this.metaCache.get((Object)key, k -> {
                try {
                    return (TBase)callable.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        return (T)((TBase)callable.call());
    }

    public void invalidate() {
        if (this.metaCache != null) {
            this.metaCache.invalidateAll();
        }
    }
}

