/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_intersect", value="_FUNC_(array1, array2) - Returns an array of the elements in the intersection of array1 and array2, without duplicates.", extended="Example:\n  > SELECT _FUNC_(array(1, 2, 3,4), array(1,2,3)) FROM src;\n  [1,2,3]")
public class GenericUDFArrayIntersect
extends AbstractGenericUDFArrayBase {
    static final int ARRAY2_IDX = 1;
    private static final String FUNC_NAME = "ARRAY_INTERSECT";
    static final String ERROR_NOT_COMPARABLE = "Input arrays are not comparable to use ARRAY_INTERSECT udf";

    public GenericUDFArrayIntersect() {
        super(FUNC_NAME, 2, 2, ObjectInspector.Category.LIST);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector defaultOI = super.initialize(arguments);
        this.checkArgCategory(arguments, 1, ObjectInspector.Category.LIST, FUNC_NAME, "array");
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.arrayOI.getListElementObjectInspector(), (ObjectInspector)((ListObjectInspector)arguments[1]).getListElementObjectInspector())) {
            throw new UDFArgumentTypeException(1, ERROR_NOT_COMPARABLE);
        }
        return defaultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        Object array2 = arguments[1].get();
        if (array == null || array2 == null) {
            return null;
        }
        ArrayList resultArray = new ArrayList(((ListObjectInspector)this.argumentOIs[0]).getList(array));
        resultArray.retainAll(((ListObjectInspector)this.argumentOIs[1]).getList(array2));
        return resultArray.stream().distinct().map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

