/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColOrCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterColOrScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprOrExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterScalarOrColumn;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ScalarNullOrCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.NDV;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.BooleanWritable;

@Description(name="or", value="a1 _FUNC_ a2 _FUNC_ ... _FUNC_ an - Logical or")
@VectorizedExpressions(value={ColOrCol.class, ScalarNullOrCol.class, FilterExprOrExpr.class, FilterColOrScalar.class, FilterScalarOrColumn.class})
@NDV(maxNdv=2L)
@UDFType(deterministic=true, commutative=true)
public class GenericUDFOPOr
extends GenericUDF {
    private final BooleanWritable result = new BooleanWritable();
    private transient BooleanObjectInspector[] boi;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("The operator 'OR' accepts at least 2 arguments.");
        }
        this.boi = new BooleanObjectInspector[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            this.boi[i] = !(arguments[i] instanceof BooleanObjectInspector) ? PrimitiveObjectInspectorFactory.writableBooleanObjectInspector : (BooleanObjectInspector)arguments[i];
        }
        return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        boolean notNull = true;
        for (int i = 0; i < arguments.length; ++i) {
            Object a = arguments[i].get();
            if (a != null) {
                boolean bool_a = this.boi[i].get(a);
                if (!bool_a) continue;
                this.result.set(true);
                return this.result;
            }
            notNull = false;
        }
        if (notNull) {
            this.result.set(false);
            return this.result;
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (String or : children) {
            if (!first) {
                sb.append(" or ");
            } else {
                first = false;
            }
            sb.append(or);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public GenericUDF negative() {
        return new GenericUDFOPAnd();
    }
}

