/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hudi.client.utils;

import org.apache.hudi.common.util.collection.ClosableIterator;

import java.util.Iterator;
import java.util.List;

/**
 * Provides closeable iterator interface over list of iterators. Consumes all records from first iterator element
 * before moving to next iterator in the list. That is concatenating elements across multiple iterators.
 */
public class CloseableConcatenatingIterator<T> extends ConcatenatingIterator<T> {

  public CloseableConcatenatingIterator(List<ClosableIterator<T>> iterators) {
    super(iterators);
  }

  @Override
  protected Iterator<T> advanceIterator() {
    ClosableIterator<T> previous = (ClosableIterator<T>) super.advanceIterator();
    previous.close();
    return previous;
  }
}
