/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.upload;

import com.beust.jcommander.Parameter;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.yardstick.upload.StreamerParams;
import org.jetbrains.annotations.Nullable;

public class UploadBenchmarkArguments
implements StreamerParams {
    @Parameter(names={"--disable-wal"}, arity=1, description="Upload benchmark only: turn off Write Ahead Log before data uploading and turn it on again when upload is done.")
    private boolean disableWal = false;
    @Parameter(names={"--sql-jdbc-params"}, variableArity=true, description="Upload benchmark only: Additional url parameters (space separated key=value) for special JDBC connection that only uploads data. ")
    private List<String> uploadJdbcParams = Collections.emptyList();
    @Parameter(names={"--sql-copy-packet-size"}, description="Upload benchmark only: use custom packet_size (in bytes) for copy command.")
    private Long copyPacketSize = null;
    @Parameter(names={"--streamer-node-buf-size"}, description="Streamer benchmarks only: Set streamer's perNodeBufferSize property")
    private Integer streamerNodeBufSize = null;
    @Parameter(names={"--streamer-node-par-ops"}, description="Streamer benchmarks only: Set streamer's perNodeParallelOperations property")
    private Integer streamerNodeParOps = null;
    @Parameter(names={"--streamer-local-batch-size"}, description="Streamer benchmarks only: collect entries before passing to java streamer api.If set to 1, than entries will be passed directly.")
    private Integer streamerLocBatchSize = null;
    @Parameter(names={"--streamer-allow-overwrite"}, arity=1, description="Streamer benchmarks only: set allowOverwrite streamer parameter.")
    private Boolean streamerAllowOverwrite = null;
    @Parameter(names={"--streamer-ordered"}, arity=1, description="Streamer benchmarks only: set streamer ordered flag.")
    private boolean streamerOrdered = false;
    @Parameter(names={"--upload-warmup-rows"})
    private long warmupRowsCnt = 3000000L;
    @Parameter(names={"--upload-rows"})
    private long uploadRowsCnt = -1L;
    @Parameter(names={"--upload-jdbc-batch-size"})
    private long jdbcBatchSize = -1L;
    @Parameter(names={"--use-streaming"}, arity=1, description="Upload data in insert benchmarks in streaming mode")
    private boolean useStreaming = false;
    @Parameter(names={"--idx-count"})
    private int idxCnt = 0;

    public boolean disableWal() {
        return this.disableWal;
    }

    public List<String> uploadJdbcParams() {
        return this.uploadJdbcParams;
    }

    @Nullable
    public Long copyPacketSize() {
        return this.copyPacketSize;
    }

    @Override
    @Nullable
    public Integer streamerPerNodeBufferSize() {
        return this.streamerNodeBufSize;
    }

    @Override
    @Nullable
    public Integer streamerPerNodeParallelOperations() {
        return this.streamerNodeParOps;
    }

    @Override
    @Nullable
    public Integer streamerLocalBatchSize() {
        return this.streamerLocBatchSize;
    }

    @Override
    @Nullable
    public Boolean streamerAllowOverwrite() {
        return this.streamerAllowOverwrite;
    }

    @Override
    public boolean streamerOrdered() {
        return this.streamerOrdered;
    }

    public long warmupRowsCnt() {
        return this.warmupRowsCnt;
    }

    public long uploadRowsCnt() {
        if (this.uploadRowsCnt < 0L) {
            throw new IllegalStateException("Upload rows count is not specified. Check arguments.");
        }
        return this.uploadRowsCnt;
    }

    public long jdbcBatchSize() {
        if (this.jdbcBatchSize < 0L) {
            throw new IllegalStateException("JDBC batch size is not specified. Check arguments.");
        }
        return this.jdbcBatchSize;
    }

    public boolean useStreaming() {
        return this.useStreaming;
    }

    public int indexesCount() {
        return this.idxCnt;
    }

    public String toString() {
        return GridToStringBuilder.toString(UploadBenchmarkArguments.class, (Object)this);
    }
}

