/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import org.apache.ignite.internal.network.message.ScaleCubeMessage;
import org.apache.ignite.internal.network.message.ScaleCubeMessageImpl;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class ScaleCubeMessageSerializer
implements MessageSerializer<ScaleCubeMessage> {
    public static final ScaleCubeMessageSerializer INSTANCE = new ScaleCubeMessageSerializer();

    private ScaleCubeMessageSerializer() {
    }

    public boolean writeMessage(ScaleCubeMessage msg, MessageWriter writer) throws MessageMappingException {
        ScaleCubeMessageImpl message = (ScaleCubeMessageImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)3)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeByteArray("dataByteArray", message.dataByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMap("headers", message.headers(), MessageCollectionItemType.STRING, MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeMessage("message", message.message());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

