/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.command;

import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommand;
import org.apache.ignite.internal.partition.replicator.network.command.FinishTxCommandImpl;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class FinishTxCommandSerializer
implements MessageSerializer<FinishTxCommand> {
    public static final FinishTxCommandSerializer INSTANCE = new FinishTxCommandSerializer();

    private FinishTxCommandSerializer() {
    }

    public boolean writeMessage(FinishTxCommand msg, MessageWriter writer) throws MessageMappingException {
        FinishTxCommandImpl message = (FinishTxCommandImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)7)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("commit", message.commit());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeBoolean("full", message.full());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeHybridTimestamp("initiatorTime", message.initiatorTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeList("partitionIds", message.partitionIds(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeHybridTimestamp("safeTime", message.safeTime());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

