/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util.timer;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.raft.jraft.util.ExecutorServiceHelper;
import org.apache.ignite.raft.jraft.util.Requires;
import org.apache.ignite.raft.jraft.util.ThreadPoolUtil;
import org.apache.ignite.raft.jraft.util.timer.Timeout;
import org.apache.ignite.raft.jraft.util.timer.Timer;
import org.apache.ignite.raft.jraft.util.timer.TimerTask;

public class DefaultTimer
implements Timer {
    private static final IgniteLogger LOG = Loggers.forClass(DefaultTimer.class);
    private final ScheduledExecutorService scheduledExecutorService;

    public DefaultTimer(int workerNum, String name) {
        this.scheduledExecutorService = ThreadPoolUtil.newScheduledBuilder().coreThreads(workerNum).poolName(name).enableMetric(true).threadFactory((ThreadFactory)new NamedThreadFactory(name, true, LOG)).build();
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        Requires.requireNonNull(task, "task");
        Requires.requireNonNull(unit, "unit");
        TimeoutTask timeoutTask = new TimeoutTask(task);
        ScheduledFuture<?> future = this.scheduledExecutorService.schedule(new TimeoutTask(task), delay, unit);
        timeoutTask.setFuture(future);
        return timeoutTask.getTimeout();
    }

    @Override
    public Set<Timeout> stop() {
        ExecutorServiceHelper.shutdownAndAwaitTermination(this.scheduledExecutorService);
        return Collections.emptySet();
    }

    private class TimeoutTask
    implements Runnable {
        private final TimerTask task;
        private final Timeout timeout;
        private volatile ScheduledFuture<?> future;

        private TimeoutTask(final TimerTask task) {
            this.task = task;
            this.timeout = new Timeout(){

                @Override
                public Timer timer() {
                    return DefaultTimer.this;
                }

                @Override
                public TimerTask task() {
                    return task;
                }

                @Override
                public boolean isExpired() {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    ScheduledFuture<?> f = TimeoutTask.this.future;
                    return f != null && f.isCancelled();
                }

                @Override
                public boolean cancel() {
                    ScheduledFuture<?> f = TimeoutTask.this.future;
                    return f != null && f.cancel(false);
                }
            };
        }

        public Timeout getTimeout() {
            return this.timeout;
        }

        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        @Override
        public void run() {
            try {
                this.task.run(this.timeout);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

