/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.interpreter.Source;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JoinNode
implements Node {
    private final Source leftSource;
    private final Source rightSource;
    private final Sink sink;
    private final Join rel;
    private final Scalar condition;
    private final Context context;

    public JoinNode(Compiler compiler, Join rel) {
        this.leftSource = compiler.source(rel, 0);
        this.rightSource = compiler.source(rel, 1);
        this.sink = compiler.sink(rel);
        this.condition = compiler.compile((List<RexNode>)ImmutableList.of((Object)rel.getCondition()), compiler.combinedRowType(rel.getInputs()));
        this.rel = rel;
        this.context = compiler.createContext();
    }

    @Override
    public void close() {
        this.leftSource.close();
        this.rightSource.close();
    }

    @Override
    public void run() throws InterruptedException {
        int fieldCount = this.rel.getLeft().getRowType().getFieldCount() + this.rel.getRight().getRowType().getFieldCount();
        this.context.values = new Object[fieldCount];
        Source outerSource = this.leftSource;
        Source innerSource = this.rightSource;
        if (this.rel.getJoinType() == JoinRelType.RIGHT) {
            outerSource = this.rightSource;
            innerSource = this.leftSource;
        }
        Row outerRow = null;
        ArrayList<Row> innerRows = null;
        HashSet<Row> matchRowSet = new HashSet<Row>();
        while ((outerRow = outerSource.receive()) != null) {
            if (innerRows == null) {
                innerRows = new ArrayList<Row>();
                Row innerRow = null;
                while ((innerRow = innerSource.receive()) != null) {
                    innerRows.add(innerRow);
                }
            }
            matchRowSet.addAll(this.doJoin(outerRow, innerRows, this.rel.getJoinType()));
        }
        if (this.rel.getJoinType() == JoinRelType.FULL) {
            ArrayList<Row> empty = new ArrayList<Row>();
            for (Row row : (List)Objects.requireNonNull(innerRows, "innerRows")) {
                if (matchRowSet.contains(row)) continue;
                this.doSend(row, empty, JoinRelType.RIGHT);
            }
        }
    }

    private List<Row> doJoin(Row outerRow, List<Row> innerRows, JoinRelType joinRelType) throws InterruptedException {
        boolean outerRowOnLeft = joinRelType != JoinRelType.RIGHT;
        this.copyToContext(outerRow, outerRowOnLeft);
        ArrayList<Row> matchInnerRows = new ArrayList<Row>();
        for (Row innerRow : innerRows) {
            this.copyToContext(innerRow, !outerRowOnLeft);
            Boolean execute = (Boolean)this.condition.execute(this.context);
            if (execute == null || !execute.booleanValue()) continue;
            matchInnerRows.add(innerRow);
        }
        this.doSend(outerRow, matchInnerRows, joinRelType);
        return matchInnerRows;
    }

    private void doSend(Row outerRow, List<Row> matchInnerRows, JoinRelType joinRelType) throws InterruptedException {
        block10: {
            block9: {
                if (matchInnerRows.isEmpty()) break block9;
                switch (joinRelType) {
                    case INNER: 
                    case LEFT: 
                    case RIGHT: 
                    case FULL: {
                        boolean outerRowOnLeft = joinRelType != JoinRelType.RIGHT;
                        this.copyToContext(outerRow, outerRowOnLeft);
                        Objects.requireNonNull(this.context.values, "context.values");
                        for (Row row : matchInnerRows) {
                            this.copyToContext(row, !outerRowOnLeft);
                            this.sink.send(Row.asCopy(this.context.values));
                        }
                        break block10;
                    }
                    case SEMI: {
                        this.sink.send(Row.asCopy(outerRow.getValues()));
                        break;
                    }
                }
                break block10;
            }
            switch (joinRelType) {
                case LEFT: 
                case RIGHT: 
                case FULL: {
                    Objects.requireNonNull(this.context.values, "context.values");
                    int nullColumnNum = this.context.values.length - outerRow.size();
                    this.copyToContext(outerRow, joinRelType.generatesNullsOnRight());
                    int nullColumnStart = joinRelType.generatesNullsOnRight() ? outerRow.size() : 0;
                    System.arraycopy(new Object[nullColumnNum], 0, this.context.values, nullColumnStart, nullColumnNum);
                    this.sink.send(Row.asCopy(this.context.values));
                    break;
                }
                case ANTI: {
                    this.sink.send(Row.asCopy(outerRow.getValues()));
                    break;
                }
            }
        }
    }

    private void copyToContext(Row row, boolean toLeftSide) {
        @Nullable Object[] values = row.getValues();
        Objects.requireNonNull(this.context.values, "context.values");
        if (toLeftSide) {
            System.arraycopy(values, 0, this.context.values, 0, values.length);
        } else {
            System.arraycopy(values, 0, this.context.values, this.context.values.length - values.length, values.length);
        }
    }
}

