/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.registry.impl;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.configuration.NodeConfigShowCall;
import org.apache.ignite.internal.cli.call.configuration.NodeConfigShowCallInput;
import org.apache.ignite.internal.cli.core.repl.SessionInfo;
import org.apache.ignite.internal.cli.core.repl.registry.NodeConfigRegistry;
import org.apache.ignite.internal.cli.core.repl.registry.impl.LazyObjectRef;
import org.apache.ignite.internal.cli.event.ConnectionEventListener;

@Singleton
public class NodeConfigRegistryImpl
implements NodeConfigRegistry,
ConnectionEventListener {
    private final NodeConfigShowCall nodeConfigShowCall;
    private LazyObjectRef<Config> configRef;

    public NodeConfigRegistryImpl(NodeConfigShowCall nodeConfigShowCall) {
        this.nodeConfigShowCall = nodeConfigShowCall;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        this.configRef = new LazyObjectRef<Config>(() -> this.fetchConfig(sessionInfo));
    }

    private Config fetchConfig(SessionInfo sessionInfo) {
        return ConfigFactory.parseString((String)this.nodeConfigShowCall.execute(NodeConfigShowCallInput.builder().nodeUrl(sessionInfo.nodeUrl()).build()).body().getValue());
    }

    @Override
    public void onDisconnect() {
        this.configRef = null;
    }

    @Override
    public Config config() {
        return this.configRef == null ? null : this.configRef.get();
    }
}

