/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.requests.compute.ClientComputeGetStateRequest;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskDescriptor;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.client.proto.ClientComputeJobPacker;
import org.apache.ignite.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.marshalling.Marshaller;

public class ClientComputeExecuteMapReduceRequest {
    public static CompletableFuture<Void> process(ClientMessageUnpacker in, ClientMessagePacker out, IgniteComputeInternal compute, NotificationSender notificationSender) {
        List deploymentUnits = in.unpackDeploymentUnits();
        String taskClassName = in.unpackString();
        ComputeJobDataHolder arg = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller((ClientMessageUnpacker)in);
        TaskExecution execution = compute.submitMapReduce(TaskDescriptor.builder((String)taskClassName).units(deploymentUnits).build(), (Object)arg);
        ClientComputeExecuteMapReduceRequest.sendTaskResult((TaskExecution<Object>)execution, notificationSender);
        CompletionStage idsAsync = execution.idsAsync().handle((ids, ex) -> ex == null ? ids : Collections.emptyList());
        return execution.idAsync().thenAcceptBoth(idsAsync, (id, ids) -> {
            out.packUuid(id);
            ClientComputeExecuteMapReduceRequest.packJobIds(out, ids);
        });
    }

    private static void packJobIds(ClientMessagePacker out, List<UUID> ids) {
        out.packInt(ids.size());
        for (UUID uuid : ids) {
            out.packUuid(uuid);
        }
    }

    private static void sendTaskResult(TaskExecution<Object> execution, NotificationSender notificationSender) {
        TaskExecution<Object> t = execution;
        execution.resultAsync().whenComplete((val, err) -> t.stateAsync().whenComplete((state, errState) -> execution.statesAsync().whenComplete((states, errStates) -> notificationSender.sendNotification(w -> {
            Marshaller resultMarshaller = ((MarshallerProvider)t).resultMarshaller();
            ClientComputeJobPacker.packJobResult((Object)val, (Marshaller)resultMarshaller, (ClientMessagePacker)w);
            ClientComputeGetStateRequest.packTaskState(w, state);
            ClientComputeExecuteMapReduceRequest.packJobStates(w, states);
        }, (Throwable)IgniteUtils.firstNotNull((Object[])new Throwable[]{err, errState, errStates})))));
    }

    private static void packJobStates(ClientMessagePacker w, List<JobState> states) {
        w.packInt(states.size());
        for (JobState state : states) {
            ClientComputeGetStateRequest.packJobState(w, state);
        }
    }
}

