/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.ExchangeActions;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class DynamicCacheChangeFailureMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    private Collection<String> cacheNames;
    private IgniteUuid id;
    private GridDhtPartitionExchangeId exchId;
    @GridToStringInclude
    private IgniteCheckedException cause;
    private transient ExchangeActions exchangeActions;

    public DynamicCacheChangeFailureMessage(ClusterNode locNode, GridDhtPartitionExchangeId exchId, IgniteCheckedException cause, Collection<String> cacheNames) {
        assert (exchId != null);
        assert (cause != null);
        assert (!F.isEmpty(cacheNames)) : cacheNames;
        this.id = IgniteUuid.fromUuid(locNode.id());
        this.exchId = exchId;
        this.cause = cause;
        this.cacheNames = cacheNames;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    public Collection<String> cacheNames() {
        return this.cacheNames;
    }

    public IgniteCheckedException error() {
        return this.cause;
    }

    public ExchangeActions exchangeActions() {
        return this.exchangeActions;
    }

    public void exchangeActions(ExchangeActions exchangeActions) {
        assert (exchangeActions != null && !exchangeActions.empty()) : exchangeActions;
        this.exchangeActions = exchangeActions;
    }

    @Nullable
    public GridDhtPartitionExchangeId exchangeId() {
        return this.exchId;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        return mgr.createDiscoCacheOnCacheChange(topVer, discoCache);
    }

    public String toString() {
        return S.toString(DynamicCacheChangeFailureMessage.class, this);
    }
}

