/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.util.GridIntList;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.apache.ignite.transactions.TransactionState;

public class TransactionView {
    private final IgniteInternalTx tx;

    public TransactionView(IgniteInternalTx tx) {
        this.tx = tx;
    }

    public UUID localNodeId() {
        return this.tx.nodeId();
    }

    public long threadId() {
        return this.tx.threadId();
    }

    @Order(value=4)
    public long startTime() {
        return this.tx.startTime();
    }

    @Order(value=5)
    public TransactionIsolation isolation() {
        return this.tx.isolation();
    }

    @Order(value=6)
    public TransactionConcurrency concurrency() {
        return this.tx.concurrency();
    }

    @Order(value=1)
    public TransactionState state() {
        return this.tx.state();
    }

    public long timeout() {
        return this.tx.timeout();
    }

    public boolean implicit() {
        return this.tx.implicit();
    }

    @Order(value=2)
    public IgniteUuid xid() {
        return this.tx.xid();
    }

    public boolean system() {
        return this.tx.system();
    }

    public boolean implicitSingle() {
        return this.tx.implicitSingle();
    }

    public boolean near() {
        return this.tx.near();
    }

    public boolean dht() {
        return this.tx.dht();
    }

    public boolean colocated() {
        return this.tx.colocated();
    }

    public boolean local() {
        return this.tx.local();
    }

    public UUID subjectId() {
        return this.tx.subjectId();
    }

    @Order(value=3)
    public String label() {
        return this.tx.label();
    }

    public boolean onePhaseCommit() {
        return this.tx.onePhaseCommit();
    }

    public boolean internal() {
        return this.tx.internal();
    }

    @Order
    public UUID originatingNodeId() {
        return this.tx.originatingNodeId();
    }

    public UUID otherNodeId() {
        return this.tx.otherNodeId();
    }

    public String topVer() {
        return Objects.toString(this.tx.topologyVersion());
    }

    public long duration() {
        return U.currentTimeMillis() - this.tx.startTime();
    }

    @Order(value=7)
    public int keysCount() {
        Collection<IgniteTxEntry> entries = this.tx.allEntries();
        if (entries == null) {
            return 0;
        }
        return entries.size();
    }

    @Order(value=8)
    public String cacheIds() {
        GridIntList cacheIds = this.tx.txState().cacheIds();
        if (cacheIds == null) {
            return null;
        }
        int sz = cacheIds.size();
        if (sz == 0) {
            return null;
        }
        try {
            SB b = new SB();
            for (int i = 0; i < sz; ++i) {
                if (i != 0) {
                    b.a(',');
                }
                b.a(cacheIds.get(i));
            }
            return b.toString();
        }
        catch (Throwable e) {
            return null;
        }
    }
}

