/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.metadata.extent.Extent;
import org.opengis.util.InternationalString;

public class DefaultObjectDomain
extends FormattableObject
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = 5797839090924498526L;
    protected final InternationalString scope;
    protected final Extent domainOfValidity;

    public DefaultObjectDomain(InternationalString scope, Extent domainOfValidity) {
        this.scope = scope;
        this.domainOfValidity = domainOfValidity;
    }

    public InternationalString getScope() {
        return this.scope != null ? this.scope : UnknownScope.INSTANCE;
    }

    public Extent getDomainOfValidity() {
        return this.domainOfValidity != null ? this.domainOfValidity : UnknownExtent.INSTANCE;
    }

    public final boolean equals(Object object) {
        boolean eq = this.equals(object, ComparisonMode.STRICT);
        assert (!eq || this.hashCode() == object.hashCode()) : this;
        return eq;
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (mode == ComparisonMode.STRICT) {
            if (object != null && object.getClass() == this.getClass()) {
                DefaultObjectDomain that = (DefaultObjectDomain)object;
                return Objects.equals(this.scope, that.scope) && Objects.equals(this.domainOfValidity, that.domainOfValidity);
            }
        } else if (object instanceof DefaultObjectDomain) {
            DefaultObjectDomain that = (DefaultObjectDomain)object;
            return Utilities.deepEquals((Object)this.getScope(), (Object)that.getScope(), (ComparisonMode)mode) && Utilities.deepEquals((Object)this.getDomainOfValidity(), (Object)that.getDomainOfValidity(), (ComparisonMode)mode);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.scope, this.domainOfValidity);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        formatter.append(this.scope, this.domainOfValidity);
        return "Usage";
    }

    private static final class UnknownScope
    extends Vocabulary.International
    implements NilObject {
        private static final long serialVersionUID = 7235301883912422934L;
        static final UnknownScope INSTANCE = new UnknownScope();

        private UnknownScope() {
            super((short)207);
        }

        public NilReason getNilReason() {
            return NilReason.UNKNOWN;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static final class UnknownExtent
    extends DefaultExtent
    implements NilObject {
        private static final long serialVersionUID = 662383891780679068L;
        static final UnknownExtent INSTANCE = new UnknownExtent();

        private UnknownExtent() {
            super((CharSequence)((Object)UnknownScope.INSTANCE), null, null, null);
            this.transitionTo(ModifiableMetadata.State.FINAL);
        }

        public NilReason getNilReason() {
            return NilReason.UNKNOWN;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

