/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.folder;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.aggregate.CoverageAggregator;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.folder.ConcurrentCloser;
import org.apache.sis.storage.folder.StoreProvider;
import org.apache.sis.storage.folder.UnstructuredAggregate;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;

class Store
extends DataStore
implements StoreResource,
UnstructuredAggregate,
DirectoryStream.Filter<Path> {
    private final Store originator;
    protected final Path location;
    private GenericName identifier;
    protected final Locale locale;
    protected final TimeZone timezone;
    protected final Charset encoding;
    final Map<Path, DataStore> children;
    private transient Metadata metadata;
    transient Collection<Resource> components;
    protected final DataStoreProvider componentProvider;
    private transient boolean sharedRepositoryReported;
    private transient Resource structuredView;

    Store(DataStoreProvider provider, StorageConnector connector, Path path, DataStoreProvider format) throws DataStoreException, IOException {
        super(provider, connector);
        this.originator = this;
        this.location = path;
        this.locale = (Locale)connector.getOption(OptionKey.LOCALE);
        this.timezone = (TimeZone)connector.getOption(OptionKey.TIMEZONE);
        this.encoding = (Charset)connector.getOption(OptionKey.ENCODING);
        this.children = new ConcurrentHashMap<Path, DataStore>();
        this.children.put(path.toRealPath(new LinkOption[0]), this);
        this.componentProvider = format;
    }

    private Store(Store parent, StorageConnector connector, NameFactory nameFactory) throws DataStoreException {
        super(parent, parent.getProvider(), connector, false);
        this.originator = parent;
        this.locale = (Locale)connector.getOption(OptionKey.LOCALE);
        this.timezone = (TimeZone)connector.getOption(OptionKey.TIMEZONE);
        this.encoding = (Charset)connector.getOption(OptionKey.ENCODING);
        this.location = connector.commit(Path.class, "folder");
        this.children = parent.children;
        this.componentProvider = parent.componentProvider;
        this.identifier = nameFactory.createLocalName(parent.identifier(nameFactory).scope(), (CharSequence)super.getDisplayName());
    }

    @Override
    public DataStore getOriginator() {
        return this.originator;
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        String format = StoreUtilities.getFormatName(this.componentProvider);
        ParameterValueGroup pg = (this.provider != null ? this.provider.getOpenParameters() : StoreProvider.PARAMETERS).createValue();
        pg.parameter("location").setValue((Object)this.location);
        if (this.locale != null) {
            pg.parameter("locale").setValue((Object)this.locale);
        }
        if (this.timezone != null) {
            pg.parameter("timezone").setValue((Object)this.timezone);
        }
        if (this.encoding != null) {
            pg.parameter("encoding").setValue((Object)this.encoding);
        }
        if (format != null) {
            pg.parameter("format").setValue((Object)format);
        }
        return Optional.of(pg);
    }

    @Override
    public boolean accept(Path entry) throws IOException {
        return !Files.isHidden(entry);
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.of(this.identifier(null));
    }

    private synchronized GenericName identifier(NameFactory nameFactory) {
        if (this.identifier == null) {
            if (nameFactory == null) {
                nameFactory = DefaultNameFactory.provider();
            }
            LocalName name = nameFactory.createLocalName(null, (CharSequence)super.getDisplayName());
            NameSpace ns = nameFactory.createNameSpace((GenericName)name, Map.of("separator", "/"));
            this.identifier = nameFactory.createLocalName(ns, (CharSequence)".");
        }
        return this.identifier;
    }

    @Override
    public synchronized Metadata getMetadata() {
        if (this.metadata == null) {
            MetadataBuilder mb = new MetadataBuilder();
            mb.addResourceScope(ScopeCode.valueOf((String)"COLLECTION"), (CharSequence)Resources.formatInternational((short)35, this.getDisplayName()));
            mb.addLanguage(this.locale, this.encoding, MetadataBuilder.Scope.RESOURCE);
            GenericName identifier = this.identifier(null);
            String name = null;
            if (identifier != null && ".".equals(name = identifier.toString())) {
                name = null;
            }
            if (name == null) {
                name = super.getDisplayName();
            }
            mb.addTitleOrIdentifier(name, MetadataBuilder.Scope.RESOURCE);
            this.metadata = mb.buildAndFreeze();
        }
        return this.metadata;
    }

    public synchronized Collection<Resource> components() throws DataStoreException {
        if (this.components == null) {
            ArrayList<DataStore> resources = new ArrayList<DataStore>();
            DefaultNameFactory nameFactory = DefaultNameFactory.provider();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.location, this);){
                for (Path candidate : stream) {
                    Path real = candidate.toRealPath(new LinkOption[0]);
                    DataStore next = this.children.get(real);
                    if (next instanceof Store) {
                        ((Store)next).sharedRepository(real);
                    }
                    if (next == null) {
                        block25: {
                            StorageConnector connector = new StorageConnector(candidate);
                            connector.setOption(OptionKey.LOCALE, this.locale);
                            connector.setOption(OptionKey.TIMEZONE, this.timezone);
                            connector.setOption(OptionKey.ENCODING, this.encoding);
                            connector.setOption(DataOptionKey.PARENT_LISTENERS, this.listeners);
                            try {
                                if (this.componentProvider == null) {
                                    next = DataStores.open(connector);
                                    break block25;
                                }
                                if (this.componentProvider.probeContent(connector).isSupported()) {
                                    next = this.componentProvider.open(connector);
                                    break block25;
                                }
                                if (Files.isDirectory(candidate, new LinkOption[0])) {
                                    next = new Store(this, connector, (NameFactory)nameFactory);
                                    break block25;
                                }
                                connector.closeAllExcept(null);
                                continue;
                            }
                            catch (UnsupportedStorageException ex) {
                                if (!Files.isDirectory(candidate, new LinkOption[0])) {
                                    connector.closeAllExcept(null);
                                    this.listeners.warning(Level.FINE, null, ex);
                                    continue;
                                }
                                next = new Store(this, connector, (NameFactory)nameFactory);
                            }
                            catch (DataStoreException ex) {
                                try {
                                    connector.closeAllExcept(null);
                                }
                                catch (DataStoreException s) {
                                    ex.addSuppressed(s);
                                }
                                throw ex;
                            }
                        }
                        DataStore existing = this.children.putIfAbsent(real, next);
                        if (existing != null) {
                            next.close();
                            next = existing;
                            if (next instanceof Store) {
                                ((Store)next).sharedRepository(real);
                            }
                        }
                    }
                    resources.add(next);
                }
            }
            catch (UncheckedIOException | DirectoryIteratorException ex) {
                throw new DataStoreException(this.canNotRead(), ex.getCause());
            }
            catch (IOException ex) {
                throw new DataStoreException(this.canNotRead(), ex);
            }
            catch (BackingStoreException ex) {
                throw (DataStoreException)ex.unwrapOrRethrow(DataStoreException.class);
            }
            this.components = UnmodifiableArrayList.wrap((Object[])((Resource[])resources.toArray(Resource[]::new)));
        }
        return this.components;
    }

    private String canNotRead() {
        return this.message((short)34, this.getDisplayName());
    }

    private void sharedRepository(Path candidate) {
        if (!this.sharedRepositoryReported) {
            this.sharedRepositoryReported = true;
            this.listeners.warning(this.message((short)36, candidate));
        }
    }

    @Override
    public synchronized Resource getStructuredView() throws DataStoreException {
        if (this.structuredView == null) {
            CoverageAggregator aggregator = new CoverageAggregator(this.listeners);
            aggregator.addComponents(this);
            this.structuredView = aggregator.build(this.identifier);
        }
        return this.structuredView;
    }

    final Resources messages() {
        return Resources.forLocale(this.getLocale());
    }

    final String message(short key, Object value) {
        return this.messages().getString(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DataStoreException {
        Collection<Resource> resources;
        this.listeners.close();
        Store store = this;
        synchronized (store) {
            resources = this.components;
            this.components = List.of();
            this.identifier = null;
            this.metadata = null;
            this.structuredView = null;
            this.children.clear();
        }
        if (resources != null && !resources.isEmpty()) {
            ConcurrentCloser.RESOURCES.closeAll(resources);
        }
    }
}

