/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sis.pending.geoapi.filter.SortOrder;
import org.apache.sis.pending.geoapi.filter.SortProperty;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;

final class DefaultSortProperty<R>
implements SortProperty<R>,
Serializable {
    private static final long serialVersionUID = 6065805794498223206L;
    private final ValueReference<R, ?> property;
    private final boolean descending;

    DefaultSortProperty(ValueReference<R, ?> property, SortOrder order) {
        ArgumentChecks.ensureNonNull((String)"property", property);
        ArgumentChecks.ensureNonNull((String)"order", (Object)((Object)order));
        this.property = property;
        this.descending = SortOrder.DESCENDING.equals((Object)order);
    }

    @Override
    public ValueReference<R, ?> getValueReference() {
        return this.property;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.descending ? SortOrder.DESCENDING : SortOrder.ASCENDING;
    }

    @Override
    public int compare(R r1, R r2) {
        if (this.descending) {
            R rt = r1;
            r1 = r2;
            r2 = rt;
        }
        if (r1 == null) {
            return 1;
        }
        if (r2 == null) {
            return -1;
        }
        Object o1 = this.property.apply(r1);
        Object o2 = this.property.apply(r2);
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1 instanceof Iterable) {
            return Containers.compare(((Iterable)o1).iterator(), (Iterator)DefaultSortProperty.iterator(o2));
        }
        if (o2 instanceof Iterable) {
            return Containers.compare((Iterator)DefaultSortProperty.iterator(o1), ((Iterable)o2).iterator());
        }
        throw new ClassCastException(Errors.format((short)59, (Object)this.property.getXPath(), Comparable.class, (o1 instanceof Comparable ? o2 : o1).getClass()));
    }

    private static Iterator iterator(Object o) {
        return o instanceof Iterable ? ((Iterable)o).iterator() : Collections.singleton(o).iterator();
    }

    public int hashCode() {
        return this.property.hashCode() + Boolean.hashCode(this.descending);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultSortProperty) {
            DefaultSortProperty other = (DefaultSortProperty)obj;
            return this.descending == other.descending && this.property.equals(other.property);
        }
        return false;
    }
}

