/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.raster;

import java.awt.image.BufferedImage;
import org.apache.baremaps.dem.ElevationUtils;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.apache.baremaps.tilestore.raster.GeoTiffReader;

public class TerrariumTileStore
implements TileStore<BufferedImage> {
    private final GeoTiffReader geoTiffReader;

    public TerrariumTileStore(GeoTiffReader geoTiffReader) {
        this.geoTiffReader = geoTiffReader;
    }

    @Override
    public BufferedImage read(TileCoord tileCoord) throws TileStoreException {
        try {
            int size = 256;
            double[] grid = this.geoTiffReader.read(tileCoord, size, 0);
            BufferedImage bufferedImage = new BufferedImage(size, size, 1);
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < size; ++y) {
                    double value = (int)grid[y * size + x];
                    int rgb = ElevationUtils.elevationToTerrarium((double)value);
                    bufferedImage.setRGB(x, y, rgb);
                }
            }
            return bufferedImage;
        }
        catch (Exception e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void write(TileCoord tileCoord, BufferedImage blob) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
        this.geoTiffReader.close();
    }
}

