/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.client;

import com.google.common.collect.Maps;
import com.xiaomi.data.push.client.bo.HttpResult;
import com.xiaomi.data.push.client.bo.OkHttpReq;
import com.xiaomi.data.push.client.common.PrintingEventListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoneHttpClient {
    private static final Logger log = LoggerFactory.getLogger(MoneHttpClient.class);
    private OkHttpClient client = null;
    private int poolNum = 20;
    private ConcurrentHashMap<String, ConnectionPool> poolMap = new ConcurrentHashMap();
    public static BiFunction<Response, Call, HttpResult> getResFun = (res, call) -> {
        byte[] data = new byte[]{};
        try {
            data = res.body().source().readByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        HttpResult result = new HttpResult();
        result.setData(data);
        result.setCode(res.code());
        HashMap h = Maps.newHashMap();
        res.headers().forEach(it -> {
            log.debug("{}->{}", it.getFirst(), it.getSecond());
            h.put((String)it.getFirst(), (String)it.getSecond());
        });
        result.setRespHeaders(h);
        result.setCall(call);
        return result;
    };

    public MoneHttpClient(int timeout, int poolNum) {
        this.poolNum = poolNum;
        this.client = new OkHttpClient.Builder().eventListenerFactory(PrintingEventListener.FACTORY).callTimeout((long)timeout, TimeUnit.MILLISECONDS).build();
    }

    public String info() {
        return "poolNum:" + this.poolNum;
    }

    public HttpResult get(String group, String url, Map<String, String> headers, int timeout) {
        Call call = this.getCall(group, "get", url, headers, null, timeout, null);
        return this.call(call, getResFun);
    }

    public HttpResult post(String group, String url, Map<String, String> headers, byte[] data, int timeout) {
        Call call = this.getCall(group, "post", url, headers, data, timeout, null);
        return this.call(call, getResFun);
    }

    public Call getCall(String group, String method, String url, Map<String, String> headers, byte[] data, int timeout, OkHttpReq okHttpReq) {
        ConnectionPool groupPool = this.poolMap.computeIfAbsent(String.valueOf(group.hashCode() % this.poolNum), k -> new ConnectionPool(20, 5L, TimeUnit.MINUTES));
        OkHttpClient.Builder clientBuilder = this.client.newBuilder().connectionPool(groupPool).callTimeout((long)timeout, TimeUnit.MILLISECONDS);
        if (null != okHttpReq && null != okHttpReq.getProtocolList()) {
            clientBuilder.protocols(okHttpReq.getProtocolList());
        }
        OkHttpClient client = clientBuilder.build();
        Headers.Builder headersBuilder = new Headers.Builder();
        headers.forEach((k, v) -> headersBuilder.add(k, v));
        Request.Builder builder = new Request.Builder().url(url).headers(headersBuilder.build());
        if (method.equals("post")) {
            RequestBody requestBody = RequestBody.create((byte[])data);
            builder.post(requestBody);
        }
        Request req = builder.build();
        Call call = client.newCall(req);
        return call;
    }

    public HttpResult call(Call call, BiFunction<Response, Call, HttpResult> function) {
        HttpResult httpResult;
        block8: {
            Response res = call.execute();
            try {
                httpResult = function.apply(res, call);
                if (res == null) break block8;
            }
            catch (Throwable throwable) {
                if (res != null) {
                    try {
                        res.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            res.close();
        }
        return httpResult;
    }

    public ConcurrentHashMap<String, ConnectionPool> getPoolMap() {
        return this.poolMap;
    }
}

