/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.util.config;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.annotation.NacosProperties;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.nacos.spring.util.PropertiesPlaceholderResolver;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;

public class NacosConfigLoader {
    private final ConfigurableEnvironment environment;
    private final ConversionService conversionService;
    private final PropertiesPlaceholderResolver resolver;
    private NacosServiceFactory nacosServiceFactory;
    private ConfigService configService;

    public NacosConfigLoader(ConfigurableEnvironment environment) {
        this.environment = environment;
        this.conversionService = environment.getConversionService();
        this.resolver = new PropertiesPlaceholderResolver((PropertyResolver)environment);
    }

    public String load(String dataId, String groupId, NacosProperties nacosProperties) throws RuntimeException {
        Properties properties = this.resolver.resolve((Annotation)nacosProperties);
        return this.load(dataId, groupId, properties);
    }

    public String load(String dataId, String groupId, Properties nacosProperties) throws RuntimeException {
        try {
            this.configService = this.nacosServiceFactory != null ? this.nacosServiceFactory.createConfigService(nacosProperties) : NacosFactory.createConfigService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            throw new RuntimeException("ConfigService can't be created with dataId :" + dataId + " , groupId : " + groupId + " , properties : " + nacosProperties, e);
        }
        return NacosUtils.getContent(this.configService, dataId, groupId);
    }

    public <T> T load(String dataId, String groupId, NacosProperties nacosProperties, Class<T> targetClass) throws RuntimeException {
        String config = this.load(dataId, groupId, nacosProperties);
        return (T)this.conversionService.convert((Object)config, targetClass);
    }

    public void setNacosServiceFactory(NacosServiceFactory nacosServiceFactory) {
        this.nacosServiceFactory = nacosServiceFactory;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }
}

