/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.model.pojo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import java.io.Serializable;
import java.util.List;
import org.apache.ozhera.log.api.enums.MiddlewareEnum;
import org.apache.ozhera.log.api.model.bo.MiLogResource;
import org.apache.ozhera.log.api.model.vo.EsIndexVo;
import org.apache.ozhera.log.api.model.vo.ResourceInfo;
import org.apache.ozhera.log.manager.model.BaseCommon;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.nutz.dao.entity.annotation.ColDefine;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;

@TableName(value="milog_es_cluster", autoResultMap=true)
public class MilogEsClusterDO
extends BaseCommon
implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId(value="id", type=IdType.AUTO)
    private Long id;
    @Column(value="log_storage_type")
    @ColDefine(type=ColType.VARCHAR, width=50)
    @Comment(value="Log storage type")
    private String logStorageType;
    private String tag;
    private String name;
    private String clusterName;
    private String region;
    private String area;
    private String addr;
    private String user;
    private String pwd;
    private String token;
    private String dtCatalog;
    private String dtDatabase;
    private String conWay;
    private Integer isDefault;
    @TableField(typeHandler=FastjsonTypeHandler.class)
    private List<String> labels;

    public static MilogMiddlewareConfig miLogEsResourceToConfig(MilogEsClusterDO resource) {
        MilogMiddlewareConfig milogMiddlewareConfig = new MilogMiddlewareConfig();
        milogMiddlewareConfig.setId(resource.getId());
        milogMiddlewareConfig.setAlias(resource.getName());
        milogMiddlewareConfig.setClusterName(resource.clusterName);
        milogMiddlewareConfig.setType(MiddlewareEnum.ELASTICSEARCH.getCode());
        milogMiddlewareConfig.setStorageType(resource.logStorageType);
        milogMiddlewareConfig.setRegionEn(resource.getArea());
        milogMiddlewareConfig.setServiceUrl(resource.getAddr());
        milogMiddlewareConfig.setAk(resource.getUser());
        milogMiddlewareConfig.setSk(resource.getPwd());
        milogMiddlewareConfig.setLabels(resource.getLabels());
        milogMiddlewareConfig.setCreator(resource.getCreator());
        milogMiddlewareConfig.setUpdater(resource.getUpdater());
        milogMiddlewareConfig.setUtime(resource.getUtime());
        milogMiddlewareConfig.setCtime(resource.getCtime());
        milogMiddlewareConfig.setIsDefault(resource.getIsDefault());
        return milogMiddlewareConfig;
    }

    public ResourceInfo configToResourceVO(List<EsIndexVo> multipleEsIndex) {
        return ((ResourceInfo.ResourceInfoBuilder)((ResourceInfo.ResourceInfoBuilder)((ResourceInfo.ResourceInfoBuilder)((ResourceInfo.ResourceInfoBuilder)ResourceInfo.builder().id(this.id).alias(this.name).storageType(this.logStorageType).clusterName(this.clusterName).regionEn(this.area).regionCn(CommonExtensionServiceFactory.getCommonExtensionService().getMachineRoomName(this.area)).serviceUrl(this.addr).ak(this.user).sk(this.pwd).labels(this.labels).esToken(this.token).conWay(this.conWay).catalog(this.dtCatalog).database(this.dtDatabase).multipleEsIndex(multipleEsIndex).ctime(this.getCtime())).utime(this.getUtime())).creator(this.getCreator())).updater(this.getUpdater())).build();
    }

    public static MilogEsClusterDO miLogEsResourceToConfig(MiLogResource resource) {
        MilogEsClusterDO clusterDO = new MilogEsClusterDO();
        clusterDO.setName(resource.getAlias());
        clusterDO.setClusterName(resource.getClusterName());
        clusterDO.setArea(resource.getRegionEn());
        clusterDO.setAddr(resource.getServiceUrl());
        clusterDO.setUser(resource.getAk());
        clusterDO.setPwd(resource.getSk());
        clusterDO.setLabels(resource.getLabels());
        clusterDO.setConWay(resource.getConWay());
        clusterDO.setToken(resource.getEsToken());
        clusterDO.setDtCatalog(resource.getCatalog());
        clusterDO.setDtDatabase(resource.getDatabase());
        clusterDO.setLogStorageType(resource.getStorageType());
        return clusterDO;
    }

    public Long getId() {
        return this.id;
    }

    public String getLogStorageType() {
        return this.logStorageType;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getRegion() {
        return this.region;
    }

    public String getArea() {
        return this.area;
    }

    public String getAddr() {
        return this.addr;
    }

    public String getUser() {
        return this.user;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getToken() {
        return this.token;
    }

    public String getDtCatalog() {
        return this.dtCatalog;
    }

    public String getDtDatabase() {
        return this.dtDatabase;
    }

    public String getConWay() {
        return this.conWay;
    }

    public Integer getIsDefault() {
        return this.isDefault;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setLogStorageType(String logStorageType) {
        this.logStorageType = logStorageType;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDtCatalog(String dtCatalog) {
        this.dtCatalog = dtCatalog;
    }

    public void setDtDatabase(String dtDatabase) {
        this.dtDatabase = dtDatabase;
    }

    public void setConWay(String conWay) {
        this.conWay = conWay;
    }

    public void setIsDefault(Integer isDefault) {
        this.isDefault = isDefault;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Override
    public String toString() {
        return "MilogEsClusterDO(id=" + this.getId() + ", logStorageType=" + this.getLogStorageType() + ", tag=" + this.getTag() + ", name=" + this.getName() + ", clusterName=" + this.getClusterName() + ", region=" + this.getRegion() + ", area=" + this.getArea() + ", addr=" + this.getAddr() + ", user=" + this.getUser() + ", pwd=" + this.getPwd() + ", token=" + this.getToken() + ", dtCatalog=" + this.getDtCatalog() + ", dtDatabase=" + this.getDtDatabase() + ", conWay=" + this.getConWay() + ", isDefault=" + this.getIsDefault() + ", labels=" + String.valueOf(this.getLabels()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MilogEsClusterDO)) {
            return false;
        }
        MilogEsClusterDO other = (MilogEsClusterDO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$isDefault = this.getIsDefault();
        Integer other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        String this$logStorageType = this.getLogStorageType();
        String other$logStorageType = other.getLogStorageType();
        if (this$logStorageType == null ? other$logStorageType != null : !this$logStorageType.equals(other$logStorageType)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$area = this.getArea();
        String other$area = other.getArea();
        if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
            return false;
        }
        String this$addr = this.getAddr();
        String other$addr = other.getAddr();
        if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$pwd = this.getPwd();
        String other$pwd = other.getPwd();
        if (this$pwd == null ? other$pwd != null : !this$pwd.equals(other$pwd)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$dtCatalog = this.getDtCatalog();
        String other$dtCatalog = other.getDtCatalog();
        if (this$dtCatalog == null ? other$dtCatalog != null : !this$dtCatalog.equals(other$dtCatalog)) {
            return false;
        }
        String this$dtDatabase = this.getDtDatabase();
        String other$dtDatabase = other.getDtDatabase();
        if (this$dtDatabase == null ? other$dtDatabase != null : !this$dtDatabase.equals(other$dtDatabase)) {
            return false;
        }
        String this$conWay = this.getConWay();
        String other$conWay = other.getConWay();
        if (this$conWay == null ? other$conWay != null : !this$conWay.equals(other$conWay)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MilogEsClusterDO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        String $logStorageType = this.getLogStorageType();
        result = result * 59 + ($logStorageType == null ? 43 : $logStorageType.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        String $addr = this.getAddr();
        result = result * 59 + ($addr == null ? 43 : $addr.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $pwd = this.getPwd();
        result = result * 59 + ($pwd == null ? 43 : $pwd.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $dtCatalog = this.getDtCatalog();
        result = result * 59 + ($dtCatalog == null ? 43 : $dtCatalog.hashCode());
        String $dtDatabase = this.getDtDatabase();
        result = result * 59 + ($dtDatabase == null ? 43 : $dtDatabase.hashCode());
        String $conWay = this.getConWay();
        result = result * 59 + ($conWay == null ? 43 : $conWay.hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        return result;
    }
}

