/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodParts;

public class FragmentGenerator {
    private IntrospectedTable introspectedTable;
    private String resultMapId;

    private FragmentGenerator(Builder builder) {
        this.introspectedTable = builder.introspectedTable;
        this.resultMapId = builder.resultMapId;
    }

    public String getSelectList() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IntrospectedColumn column : this.introspectedTable.getAllColumns()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(column.getJavaProperty());
        }
        return sb.toString();
    }

    public MethodParts getPrimaryKeyWhereClauseAndParameters() {
        MethodParts.Builder builder = new MethodParts.Builder();
        boolean first = true;
        for (IntrospectedColumn column : this.introspectedTable.getPrimaryKeyColumns()) {
            builder.withImport(column.getFullyQualifiedJavaType());
            builder.withParameter(new Parameter(column.getFullyQualifiedJavaType(), column.getJavaProperty() + "_"));
            if (first) {
                builder.withBodyLine("        .where(" + column.getJavaProperty() + ", isEqualTo(" + column.getJavaProperty() + "_))");
                first = false;
                continue;
            }
            builder.withBodyLine("        .and(" + column.getJavaProperty() + ", isEqualTo(" + column.getJavaProperty() + "_))");
        }
        return builder.build();
    }

    public List<String> getPrimaryKeyWhereClauseForUpdate() {
        ArrayList<String> lines = new ArrayList<String>();
        boolean first = true;
        for (IntrospectedColumn column : this.introspectedTable.getPrimaryKeyColumns()) {
            String methodName = JavaBeansUtil.getGetterMethodName(column.getJavaProperty(), column.getFullyQualifiedJavaType());
            if (first) {
                lines.add("        .where(" + column.getJavaProperty() + ", isEqualTo(record::" + methodName + "))");
                first = false;
                continue;
            }
            lines.add("        .and(" + column.getJavaProperty() + ", isEqualTo(record::" + methodName + "))");
        }
        return lines;
    }

    public MethodParts getAnnotatedConstructorArgs() {
        IntrospectedColumn introspectedColumn;
        MethodParts.Builder builder = new MethodParts.Builder();
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.type.JdbcType"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.ConstructorArgs"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Arg"));
        builder.withAnnotation("@ConstructorArgs({");
        StringBuilder sb = new StringBuilder();
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        Iterator<IntrospectedColumn> iterPk = this.introspectedTable.getPrimaryKeyColumns().iterator();
        Iterator<IntrospectedColumn> iterNonPk = this.introspectedTable.getNonPrimaryKeyColumns().iterator();
        while (iterPk.hasNext()) {
            introspectedColumn = iterPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getArgAnnotation(imports, introspectedColumn, true));
            if (iterPk.hasNext() || iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        while (iterNonPk.hasNext()) {
            introspectedColumn = iterNonPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getArgAnnotation(imports, introspectedColumn, false));
            if (iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        builder.withAnnotation("})").withImports(imports);
        return builder.build();
    }

    private String getArgAnnotation(Set<FullyQualifiedJavaType> imports, IntrospectedColumn introspectedColumn, boolean idColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("@Arg(column=\"");
        sb.append(introspectedColumn.getActualColumnName());
        imports.add(introspectedColumn.getFullyQualifiedJavaType());
        sb.append("\", javaType=");
        sb.append(introspectedColumn.getFullyQualifiedJavaType().getShortName());
        sb.append(".class");
        if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(introspectedColumn.getTypeHandler());
            imports.add(fqjt);
            sb.append(", typeHandler=");
            sb.append(fqjt.getShortName());
            sb.append(".class");
        }
        sb.append(", jdbcType=JdbcType.");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (idColumn) {
            sb.append(", id=true");
        }
        sb.append(')');
        return sb.toString();
    }

    public MethodParts getAnnotatedResults() {
        IntrospectedColumn introspectedColumn;
        MethodParts.Builder builder = new MethodParts.Builder();
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.type.JdbcType"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Result"));
        builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Results"));
        builder.withAnnotation("@Results(id=\"" + this.resultMapId + "\", value = {");
        StringBuilder sb = new StringBuilder();
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        Iterator<IntrospectedColumn> iterPk = this.introspectedTable.getPrimaryKeyColumns().iterator();
        Iterator<IntrospectedColumn> iterNonPk = this.introspectedTable.getNonPrimaryKeyColumns().iterator();
        while (iterPk.hasNext()) {
            introspectedColumn = iterPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getResultAnnotation(imports, introspectedColumn, true));
            if (iterPk.hasNext() || iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        while (iterNonPk.hasNext()) {
            introspectedColumn = iterNonPk.next();
            sb.setLength(0);
            OutputUtilities.javaIndent(sb, 1);
            sb.append(this.getResultAnnotation(imports, introspectedColumn, false));
            if (iterNonPk.hasNext()) {
                sb.append(',');
            }
            builder.withAnnotation(sb.toString());
        }
        builder.withAnnotation("})").withImports(imports);
        return builder.build();
    }

    private String getResultAnnotation(Set<FullyQualifiedJavaType> imports, IntrospectedColumn introspectedColumn, boolean idColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("@Result(column=\"");
        sb.append(introspectedColumn.getActualColumnName());
        sb.append("\", property=\"");
        sb.append(introspectedColumn.getJavaProperty());
        sb.append('\"');
        if (StringUtility.stringHasValue(introspectedColumn.getTypeHandler())) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(introspectedColumn.getTypeHandler());
            imports.add(fqjt);
            sb.append(", typeHandler=");
            sb.append(fqjt.getShortName());
            sb.append(".class");
        }
        sb.append(", jdbcType=JdbcType.");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (idColumn) {
            sb.append(", id=true");
        }
        sb.append(')');
        return sb.toString();
    }

    public MethodParts getGeneratedKeyAnnotation(GeneratedKey gk) {
        MethodParts.Builder builder = new MethodParts.Builder();
        StringBuilder sb = new StringBuilder();
        IntrospectedColumn introspectedColumn = this.introspectedTable.getColumn(gk.getColumn());
        if (introspectedColumn != null) {
            if (gk.isJdbcStandard()) {
                builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.Options"));
                sb.append("@Options(useGeneratedKeys=true,keyProperty=\"record.");
                sb.append(introspectedColumn.getJavaProperty());
                sb.append("\")");
                builder.withAnnotation(sb.toString());
            } else {
                builder.withImport(new FullyQualifiedJavaType("org.apache.ibatis.annotations.SelectKey"));
                FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
                sb.append("@SelectKey(statement=\"");
                sb.append(gk.getRuntimeSqlStatement());
                sb.append("\", keyProperty=\"record.");
                sb.append(introspectedColumn.getJavaProperty());
                sb.append("\", before=");
                sb.append(gk.isIdentity() ? "false" : "true");
                sb.append(", resultType=");
                sb.append(fqjt.getShortName());
                sb.append(".class)");
                builder.withAnnotation(sb.toString());
            }
        }
        return builder.build();
    }

    public List<String> getSetEqualLines(List<IntrospectedColumn> columnList, boolean terminate) {
        ArrayList<String> lines = new ArrayList<String>();
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(columnList);
        Iterator<IntrospectedColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            IntrospectedColumn column = iter.next();
            String methodName = JavaBeansUtil.getGetterMethodName(column.getJavaProperty(), column.getFullyQualifiedJavaType());
            String line = "        .set(" + column.getJavaProperty() + ").equalTo(record::" + methodName + ")";
            if (terminate && !iter.hasNext()) {
                line = line + ";";
            }
            lines.add(line);
        }
        return lines;
    }

    public List<String> getSetEqualWhenPresentLines(List<IntrospectedColumn> columnList, boolean terminate) {
        ArrayList<String> lines = new ArrayList<String>();
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(columnList);
        Iterator<IntrospectedColumn> iter = columns.iterator();
        while (iter.hasNext()) {
            IntrospectedColumn column = iter.next();
            String methodName = JavaBeansUtil.getGetterMethodName(column.getJavaProperty(), column.getFullyQualifiedJavaType());
            String line = "        .set(" + column.getJavaProperty() + ").equalToWhenPresent(record::" + methodName + ")";
            if (terminate && !iter.hasNext()) {
                line = line + ";";
            }
            lines.add(line);
        }
        return lines;
    }

    public static class Builder {
        private IntrospectedTable introspectedTable;
        private String resultMapId;

        public Builder withIntrospectedTable(IntrospectedTable introspectedTable) {
            this.introspectedTable = introspectedTable;
            return this;
        }

        public Builder withResultMapId(String resultMapId) {
            this.resultMapId = resultMapId;
            return this;
        }

        public FragmentGenerator build() {
            return new FragmentGenerator(this);
        }
    }
}

