/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel.locator;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Lists;
import com.xiaomi.data.push.rpc.RpcClient;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Component;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.agent.channel.ChannelDefine;
import org.apache.ozhera.log.agent.channel.conf.AgentTailConf;
import org.apache.ozhera.log.agent.channel.locator.ChannelDefineLocator;
import org.apache.ozhera.log.agent.factory.OutPutServiceFactory;
import org.apache.ozhera.log.agent.filter.FilterTrans;
import org.apache.ozhera.log.agent.input.AppLogInput;
import org.apache.ozhera.log.agent.output.Output;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.model.meta.FilterType;
import org.apache.ozhera.log.api.model.meta.LogCollectMeta;
import org.apache.ozhera.log.api.model.meta.LogPattern;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class ChannelDefineRpcLocator
implements ChannelDefineLocator {
    private static final Logger log = LoggerFactory.getLogger(ChannelDefineRpcLocator.class);

    @Override
    public List<ChannelDefine> getChannelDefine() {
        String localIp = NetUtil.getLocalIp();
        String heraK8sEnv = NetUtil.getHeraK8sEnv();
        if (StringUtils.isNotEmpty((CharSequence)heraK8sEnv)) {
            localIp = String.format("%s%s%s", localIp, ":", heraK8sEnv);
        }
        log.info("ChannelDefineRpcLocator,localIp:{},heraK8sEnv:{},ipUnique:{}", new Object[]{NetUtil.getLocalIp(), heraK8sEnv, localIp});
        return this.getChannelDefine(localIp);
    }

    @Override
    public List<ChannelDefine> getChannelDefine(String ip) {
        try {
            LogCollectMeta meta;
            int count = 0;
            while (null == (meta = this.getLogCollectMeta(ip)) || CollectionUtils.isEmpty((Collection)meta.getAppLogMetaList())) {
                TimeUnit.SECONDS.sleep(1L);
                if (++count <= 11) continue;
            }
            return ChannelDefineRpcLocator.agentTail2ChannelDefine(ChannelDefineRpcLocator.logCollectMeta2ChannelDefines(meta));
        }
        catch (Throwable ex) {
            log.error(String.format("\u3010agent pull metadata config error\u3011ip:%s", ip), ex);
            return Lists.newArrayList();
        }
    }

    private LogCollectMeta getLogCollectMeta(String ip) {
        try {
            RpcClient rpcClient = (RpcClient)Ioc.ins().getBean(RpcClient.class);
            RemotingCommand res = rpcClient.sendMessage(rpcClient.getServerAddrs(), 24680, ip, 30000L);
            String str = new String(res.getBody(), StandardCharsets.UTF_8);
            LogCollectMeta meta = (LogCollectMeta)Constant.GSON.fromJson(str, LogCollectMeta.class);
            log.info("agent getChannelDefine finish:{}", (Object)str);
            return meta;
        }
        catch (Throwable e) {
            log.error("getLogCollectMeta error,ip:{}", (Object)ip, (Object)e);
            return null;
        }
    }

    public static AgentTailConf logCollectMeta2ChannelDefines(LogCollectMeta logCollectMeta) {
        AgentTailConf agentTailConf = new AgentTailConf();
        ArrayList channelDefines = Lists.newArrayList();
        logCollectMeta.getAppLogMetaList().forEach(appLogMeta -> {
            ChannelDefine channelDefine = new ChannelDefine();
            channelDefine.setAppId(appLogMeta.getAppId());
            channelDefine.setAppName(appLogMeta.getAppName());
            channelDefine.setSingleMetaData(logCollectMeta.getSingleMetaData());
            channelDefine.setPodType(logCollectMeta.getPodType());
            channelDefine.setDelDirectory(logCollectMeta.getDelDirectory());
            List logPatternList = appLogMeta.getLogPatternList();
            for (LogPattern logPattern : logPatternList) {
                ChannelDefine cloneChannelDefine = (ChannelDefine)ObjectUtil.clone((Object)channelDefine);
                cloneChannelDefine.setChannelId(logPattern.getLogtailId());
                cloneChannelDefine.setTailName(logPattern.getTailName());
                AppLogInput input = new AppLogInput();
                input.setType(logPattern.getLogType() != null ? LogTypeEnum.getLogTypeName((Integer)logPattern.getLogType()) : "");
                input.setLogPattern(logPattern.getLogPattern());
                input.setPatternCode(logPattern.getPatternCode());
                input.setLogSplitExpress(logPattern.getLogSplitExpress());
                input.setLinePrefix(logPattern.getFirstLineReg());
                Output output = OutPutServiceFactory.getChannelDefineLocatorExtension().getOutPutByMQConfigType(logPattern);
                List filterDefines = logPattern.getFilters();
                List<Object> filters = Lists.newArrayList();
                if (filterDefines != null) {
                    filters = filterDefines.stream().map(FilterTrans::filterConfTrans).collect(Collectors.toList());
                }
                cloneChannelDefine.setIps(logPattern.getIps());
                cloneChannelDefine.setIpDirectoryRel(logPattern.getIpDirectoryRel());
                cloneChannelDefine.setFilters(filters);
                cloneChannelDefine.setInput(input);
                cloneChannelDefine.setOutput(output);
                cloneChannelDefine.setOperateEnum(logPattern.getOperateEnum());
                channelDefines.add(cloneChannelDefine);
            }
        });
        agentTailConf.setChannelDefine(channelDefines);
        agentTailConf.setAgentDefine(logCollectMeta.getAgentDefine());
        log.info("agent build metadata config:{}", (Object)Constant.GSON.toJson((Object)agentTailConf));
        return agentTailConf;
    }

    public static List<ChannelDefine> agentTail2ChannelDefine(AgentTailConf conf) {
        if (conf != null && conf.getAgentDefine() != null && CollectionUtils.isNotEmpty((Collection)conf.getAgentDefine().getFilters())) {
            List filters = conf.getAgentDefine().getFilters().stream().filter(f -> f != null && f.getType().equals((Object)FilterType.GLOBAL)).collect(Collectors.toList());
            if (conf.getChannelDefine() != null && CollectionUtils.isNotEmpty(filters)) {
                conf.getChannelDefine().forEach(c -> c.getFilters().addAll(filters));
            }
        }
        return conf.getChannelDefine();
    }
}

