/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.api.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmPresetMetrics;
import org.apache.ozhera.monitor.bo.ReqErrorMetrics;
import org.apache.ozhera.monitor.pojo.ReqErrorMetricsPOJO;
import org.apache.ozhera.monitor.service.api.ReqErrorMetricsService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class ReqErrorMetricsServiceImpl
implements ReqErrorMetricsService {
    @Override
    public ReqErrorMetricsPOJO getErrorMetricsByMetrics(String metrics) {
        if (StringUtils.isBlank((CharSequence)metrics)) {
            return null;
        }
        for (ReqErrorMetrics errMetrics : ReqErrorMetrics.values()) {
            if (errMetrics.getMetrics() == null || errMetrics.getMetrics().length == 0) continue;
            for (AlarmPresetMetrics ele : errMetrics.getMetrics()) {
                if (!ele.getCode().equals(metrics)) continue;
                return this.covert(errMetrics);
            }
        }
        return null;
    }

    private ReqErrorMetricsPOJO covert(ReqErrorMetrics metrics) {
        ReqErrorMetricsPOJO pojo = new ReqErrorMetricsPOJO();
        pojo.setCode(metrics.getCode());
        pojo.setMessage(metrics.getMessage());
        return pojo;
    }
}

