/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.skyscreamer.jsonassert.ValueMatcher;
import org.skyscreamer.jsonassert.ValueMatcherException;

public class RegularExpressionValueMatcher<T>
implements ValueMatcher<T> {
    private final Pattern expectedPattern;

    public RegularExpressionValueMatcher() {
        this(null);
    }

    public RegularExpressionValueMatcher(String pattern) throws IllegalArgumentException {
        try {
            this.expectedPattern = pattern == null ? null : Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Constant expected pattern invalid: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean equal(T actual, T expected) {
        String actualString = actual.toString();
        String expectedString = expected.toString();
        try {
            Pattern pattern;
            Pattern pattern2 = pattern = this.isStaticPattern() ? this.expectedPattern : Pattern.compile(expectedString);
            if (!pattern.matcher(actualString).matches()) {
                throw new ValueMatcherException(this.getPatternType() + " expected pattern did not match value", pattern.toString(), actualString);
            }
        }
        catch (PatternSyntaxException e) {
            throw new ValueMatcherException(this.getPatternType() + " expected pattern invalid: " + e.getMessage(), (Throwable)e, expectedString, actualString);
        }
        return true;
    }

    private boolean isStaticPattern() {
        return this.expectedPattern != null;
    }

    private String getPatternType() {
        return this.isStaticPattern() ? "Constant" : "Dynamic";
    }
}

