/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.BitSet;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.jdbc.IoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBNonAlignJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBResultMetadata;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.apache.iotdb.jdbc.IoTDBTracingInfo;
import org.apache.iotdb.rpc.IoTDBJDBCDataSet;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIoTDBJDBCResultSet
implements ResultSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIoTDBJDBCResultSet.class);
    protected Statement statement;
    protected SQLWarning warningChain = null;
    protected List<String> columnTypeList;
    protected IoTDBJDBCDataSet ioTDBRpcDataSet;
    protected IoTDBTracingInfo ioTDBRpcTracingInfo;
    private boolean isRpcFetchResult = true;
    private List<String> sgColumns;
    private BitSet aliasColumnMap;

    public AbstractIoTDBJDBCResultSet(Statement statement, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, IClientRPCService.Iface client, String sql, long queryId, long sessionId, long timeout, List<String> sgColumns, BitSet aliasColumnMap, ZoneId zoneId) throws SQLException {
        this.ioTDBRpcDataSet = new IoTDBJDBCDataSet(sql, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, queryId, ((IoTDBStatement)statement).getStmtId(), client, sessionId, null, statement.getFetchSize(), timeout, sgColumns, aliasColumnMap, zoneId);
        this.statement = statement;
        this.columnTypeList = columnTypeList;
        this.aliasColumnMap = aliasColumnMap;
    }

    protected AbstractIoTDBJDBCResultSet(Statement statement, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, IClientRPCService.Iface client, String sql, long queryId, long sessionId, long timeout, boolean isRpcFetchResult, ZoneId zoneId) throws SQLException {
        this.ioTDBRpcDataSet = new IoTDBJDBCDataSet(sql, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, queryId, ((IoTDBStatement)statement).getStmtId(), client, sessionId, null, statement.getFetchSize(), timeout, zoneId);
        this.statement = statement;
        this.columnTypeList = columnTypeList;
        this.isRpcFetchResult = isRpcFetchResult;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean absolute(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void close() throws SQLException {
        try {
            this.ioTDBRpcDataSet.close();
        }
        catch (StatementExecutionException e) {
            throw new SQLException("Error occurs for close operation in server side because ", e);
        }
        catch (TException e) {
            throw new SQLException("Error occurs when connecting to server for close operation ", e);
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int findColumn(String columnName) {
        return this.ioTDBRpcDataSet.findColumn(columnName);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array getArray(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array getArray(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            return this.getBigDecimal(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        String value = this.getValueByName(columnName);
        if (value != null) {
            return new BigDecimal(value);
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        MathContext mc = new MathContext(scale);
        return this.getBigDecimal(columnIndex).round(mc);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob getBlob(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob getBlob(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            return this.getBoolean(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getBoolean(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob getClob(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob getClob(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return new Date(this.getLong(columnIndex));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            return this.getDouble(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getDouble(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            return this.getFloat(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getFloat(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try {
            return this.getInt(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getInt(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try {
            return this.getLong(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public ResultSetMetaData getMetaData() {
        String operationType = "";
        boolean nonAlign = false;
        try {
            if (this.statement.getResultSet() instanceof IoTDBJDBCResultSet) {
                operationType = ((IoTDBJDBCResultSet)this.statement.getResultSet()).getOperationType();
                this.sgColumns = ((IoTDBJDBCResultSet)this.statement.getResultSet()).getSgColumns();
            } else if (this.statement.getResultSet() instanceof IoTDBNonAlignJDBCResultSet) {
                operationType = ((IoTDBNonAlignJDBCResultSet)this.statement.getResultSet()).getOperationType();
                this.sgColumns = ((IoTDBNonAlignJDBCResultSet)this.statement.getResultSet()).getSgColumns();
                nonAlign = true;
            }
        }
        catch (SQLException throwables) {
            LOGGER.error("Get meta data error: {}", (Object)throwables.getMessage());
        }
        return new IoTDBResultMetadata(nonAlign, this.sgColumns, operationType, this.ioTDBRpcDataSet.columnNameList, this.ioTDBRpcDataSet.columnTypeList, this.ioTDBRpcDataSet.ignoreTimeStamp);
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try {
            return this.getObject(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObjectByName(columnName);
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Ref getRef(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Ref getRef(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            return this.getString(this.ioTDBRpcDataSet.findColumnNameByIndex(columnIndex));
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getValueByName(columnName);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return new Time(this.getLong(columnIndex));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return new Timestamp(this.getLong(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warningChain;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isClosed() {
        return this.ioTDBRpcDataSet.isClosed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean next() throws SQLException {
        if (this.hasCachedResults()) {
            this.constructOneRow();
            return true;
        }
        if (this.ioTDBRpcDataSet.emptyResultSet) {
            return false;
        }
        if (this.isRpcFetchResult && this.fetchResults()) {
            this.constructOneRow();
            return true;
        }
        return false;
    }

    abstract boolean fetchResults() throws SQLException;

    abstract boolean hasCachedResults();

    abstract void constructOneRow();

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateByte(int arg0, byte arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateByte(String arg0, byte arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateDate(int arg0, Date arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateDate(String arg0, Date arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateDouble(int arg0, double arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateDouble(String arg0, double arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateFloat(int arg0, float arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateFloat(String arg0, float arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateInt(int arg0, int arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateInt(String arg0, int arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateLong(int arg0, long arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateLong(String arg0, long arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(int arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNString(int arg0, String arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNString(String arg0, String arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNull(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateNull(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateObject(int arg0, Object arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateObject(String arg0, Object arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateShort(int arg0, short arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateShort(String arg0, short arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateString(int arg0, String arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateString(String arg0, String arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateTime(int arg0, Time arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateTime(String arg0, Time arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean wasNull() {
        return this.ioTDBRpcDataSet.lastReadWasNull;
    }

    abstract void checkRecord() throws SQLException;

    abstract String getValueByName(String var1) throws SQLException;

    abstract Object getObjectByName(String var1) throws SQLException;

    public boolean isSetTracingInfo() {
        if (this.ioTDBRpcTracingInfo == null) {
            return false;
        }
        return this.ioTDBRpcTracingInfo.isSetTracingInfo();
    }

    public List<String> getActivityList() {
        return this.ioTDBRpcTracingInfo.getActivityList();
    }

    public List<Long> getElapsedTimeList() {
        return this.ioTDBRpcTracingInfo.getElapsedTimeList();
    }

    public long getStatisticsByName(String name) throws Exception {
        return this.ioTDBRpcTracingInfo.getStatisticsByName(name);
    }

    public String getStatisticsInfoByName(String name) throws Exception {
        return this.ioTDBRpcTracingInfo.getStatisticsInfoByName(name);
    }
}

