/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.load.disk;

import java.io.File;
import java.nio.file.FileStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.load.LoadFileException;
import org.apache.iotdb.db.storageengine.load.disk.ILoadDiskSelector;
import org.apache.iotdb.db.storageengine.load.disk.InheritSystemMultiDisksStrategySelector;
import org.apache.iotdb.metrics.utils.FileStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinIOSelector
extends InheritSystemMultiDisksStrategySelector {
    private static final Logger logger = LoggerFactory.getLogger(MinIOSelector.class);
    private final Map<String, String> rootDisks2DataDirsMapForLoad;

    public MinIOSelector(String[] dirs, ILoadDiskSelector.DiskDirectorySelector selector) {
        super(selector);
        if (dirs == null || dirs.length == 0) {
            this.rootDisks2DataDirsMapForLoad = Collections.emptyMap();
            logger.warn("MinIO selector requires at least one directory");
            return;
        }
        this.rootDisks2DataDirsMapForLoad = new HashMap<String, String>(dirs.length);
        Arrays.stream(dirs).filter(Objects::nonNull).forEach(dataDirPath -> {
            File dataDirFile = new File((String)dataDirPath);
            try {
                FileStore fileStore = FileStoreUtils.getFileStore((String)dataDirFile.getCanonicalPath());
                if (fileStore != null) {
                    String mountPoint = fileStore.toString();
                    this.rootDisks2DataDirsMapForLoad.put(mountPoint, (String)dataDirPath);
                    logger.info("Add {}'s mount point {}", dataDirPath, (Object)mountPoint);
                } else {
                    logger.info("Failed to find mount point {}, skip register it to map", dataDirPath);
                }
            }
            catch (Exception e) {
                logger.warn("Exception occurs when reading data dir's mount point {}", dataDirPath, (Object)e);
            }
        });
    }

    @Override
    public File selectTargetDirectory(File sourceDirectory, String fileName, boolean appendFileName, int tierLevel) throws DiskSpaceInsufficientException, LoadFileException {
        String fileDirRoot = null;
        try {
            if (sourceDirectory != null) {
                fileDirRoot = Optional.ofNullable(FileStoreUtils.getFileStore((String)sourceDirectory.getCanonicalPath())).map(Object::toString).orElse(null);
            }
        }
        catch (Exception e) {
            logger.warn("Exception occurs when reading target file's mount point {}", (Object)sourceDirectory.getAbsoluteFile(), (Object)e);
        }
        File targetFile = null;
        if (this.rootDisks2DataDirsMapForLoad.containsKey(fileDirRoot)) {
            targetFile = appendFileName ? fsFactory.getFile(this.rootDisks2DataDirsMapForLoad.get(fileDirRoot), fileName) : new File(this.rootDisks2DataDirsMapForLoad.get(fileDirRoot));
            return targetFile;
        }
        return super.selectTargetDirectory(sourceDirectory, fileName, appendFileName, tierLevel);
    }
}

