/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.function.Function;
import org.apache.james.core.quota.QuotaLimitValue;

public class QuotaValueDeserializer<T extends QuotaLimitValue<T>>
extends JsonDeserializer<T> {
    private final T unlimited;
    private final Function<Long, T> quotaFactory;

    public QuotaValueDeserializer(T unlimited, Function<Long, T> quotaFactory) {
        this.unlimited = unlimited;
        this.quotaFactory = quotaFactory;
    }

    public T deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        return this.deserialize(parser.getValueAsLong());
    }

    private T deserialize(Long value) {
        if (value == -1L) {
            return this.unlimited;
        }
        return (T)((QuotaLimitValue)this.quotaFactory.apply(value));
    }
}

