/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.ibm.icu.text.UnicodeSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class MailboxAnnotationKey {
    public static final String SLASH_CHARACTER = "/";
    public static final String TWO_SLASH_CHARACTER = "//";
    private static final UnicodeSet NAME_ANNOTATION_PATTERN = new UnicodeSet("[[a-z][A-Z][0-9]]").add((CharSequence)"/").freeze();
    public static final int MINIMUM_COMPONENTS = 2;
    public static final int MINIMUM_COMPONENTS_OF_VENDOR = 4;
    public static final int SECOND_COMPONENT_INDEX = 1;
    public static final String VENDOR_COMPONENT = "vendor";
    private final String key;

    public MailboxAnnotationKey(String key) {
        this.key = key;
        Preconditions.checkArgument((boolean)this.isValid(), (Object)"Key must start with '/' and not end with '/' and does not contain character with hex from '\u0000' to '\u00019' or {'*', '%', two consecutive '/'} ");
    }

    private boolean isValid() {
        if (StringUtils.isBlank((CharSequence)this.key)) {
            return false;
        }
        if (this.key.contains(" ")) {
            return false;
        }
        if (!this.key.startsWith(SLASH_CHARACTER)) {
            return false;
        }
        if (this.key.contains(TWO_SLASH_CHARACTER)) {
            return false;
        }
        if (this.key.endsWith(SLASH_CHARACTER)) {
            return false;
        }
        if (!NAME_ANNOTATION_PATTERN.containsAll(this.key)) {
            return false;
        }
        int componentsNo = this.countComponents();
        if (this.isVendorKey() && componentsNo < 4) {
            return false;
        }
        return componentsNo >= 2;
    }

    private boolean isVendorKey() {
        String[] components = StringUtils.split((String)this.key, (String)SLASH_CHARACTER);
        return components.length >= 2 && VENDOR_COMPONENT.equalsIgnoreCase(components[1]);
    }

    public int countComponents() {
        return StringUtils.countMatches((CharSequence)this.key, (CharSequence)SLASH_CHARACTER);
    }

    public String asString() {
        return this.key.toLowerCase(Locale.US);
    }

    public boolean isParentOrIsEqual(MailboxAnnotationKey key) {
        int thisComponentsSize;
        int thatComponentsSize = key.countComponents();
        return (thatComponentsSize == (thisComponentsSize = this.countComponents()) || thatComponentsSize == thisComponentsSize + 1) && this.isAncestorOrIsEqual(key);
    }

    public boolean isAncestorOrIsEqual(MailboxAnnotationKey key) {
        return this.asString().equals(key.asString()) || key.asString().startsWith(this.asString() + SLASH_CHARACTER);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MailboxAnnotationKey) {
            MailboxAnnotationKey anotherKey = (MailboxAnnotationKey)obj;
            return Objects.equal((Object)anotherKey.asString(), (Object)this.asString());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.asString()});
    }
}

