/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.collection;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.Properties$;
import org.apache.james.jmap.core.SetError;
import org.apache.james.jmap.core.SetError$;
import org.apache.james.jmap.json.MailboxSerializer;
import org.apache.james.jmap.mail.InvalidPatchException;
import org.apache.james.jmap.mail.InvalidPropertyException;
import org.apache.james.jmap.mail.InvalidUpdateException;
import org.apache.james.jmap.mail.IsSubscribed;
import org.apache.james.jmap.mail.IsSubscribedUpdate;
import org.apache.james.jmap.mail.MailboxGet$;
import org.apache.james.jmap.mail.MailboxPatchObject;
import org.apache.james.jmap.mail.MailboxSetRequest;
import org.apache.james.jmap.mail.MailboxSetResponse$;
import org.apache.james.jmap.mail.MailboxUpdateResponse;
import org.apache.james.jmap.mail.NameUpdate;
import org.apache.james.jmap.mail.ParentIdUpdate;
import org.apache.james.jmap.mail.ServerSetPropertyException;
import org.apache.james.jmap.mail.UnparsedMailboxId;
import org.apache.james.jmap.mail.UnsupportedPropertyUpdatedException;
import org.apache.james.jmap.mail.ValidatedMailboxPatchObject;
import org.apache.james.jmap.method.LoopInMailboxGraphException;
import org.apache.james.jmap.method.MailboxSetUpdatePerformer$MailboxUpdateResults$;
import org.apache.james.jmap.method.SystemMailboxChangeException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.Role;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.InsufficientRightsException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.PrefixedWildcard;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00115q!\u0002/^\u0011\u0003Ag!\u00026^\u0011\u0003Y\u0007\"\u0002:\u0002\t\u0003\u0019ha\u0002;\u0002!\u0003\r\n#\u001e\u0004\u0007\u0003S\f\u0001)a;\t\u0015\u0005UAA!f\u0001\n\u0003\ti\u000f\u0003\u0006\u0002&\u0011\u0011\t\u0012)A\u0005\u0003_DaA\u001d\u0003\u0005\u0002\u0005}\b\"CA8\t\u0005\u0005I\u0011\u0001B\u0003\u0011%\tI\bBI\u0001\n\u0003\u0011I\u0001C\u0005\u0002\u001e\u0012\t\t\u0011\"\u0011\u0002 \"I\u0011\u0011\u0017\u0003\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003w#\u0011\u0011!C\u0001\u0005\u001bA\u0011\"!3\u0005\u0003\u0003%\tA!\u0005\t\u0013\u0005UG!!A\u0005B\tU\u0001\"CAn\t\u0005\u0005I\u0011IAo\u0011%\ty\u000eBA\u0001\n\u0003\n\t\u000fC\u0005\u0002d\u0012\t\t\u0011\"\u0011\u0003\u001a\u001dI!QD\u0001\u0002\u0002#\u0005!q\u0004\u0004\n\u0003S\f\u0011\u0011!E\u0001\u0005CAaA]\n\u0005\u0002\te\u0002\"CAp'\u0005\u0005IQIAq\u0011%\u0011YdEA\u0001\n\u0003\u0013i\u0004C\u0005\u0003BM\t\t\u0011\"!\u0003D!I!1J\n\u0002\u0002\u0013%!Q\n\u0004\u0005o\u0006\u0001\u0005\u0010\u0003\u0006\u0002\u0016e\u0011)\u001a!C\u0001\u0003/A!\"!\n\u001a\u0005#\u0005\u000b\u0011BA\r\u0011)\t9#\u0007BK\u0002\u0013\u0005\u0011\u0011\u0006\u0005\u000b\u0003cI\"\u0011#Q\u0001\n\u0005-\u0002BCA\u001a3\tU\r\u0011\"\u0001\u00026!Q\u00111I\r\u0003\u0012\u0003\u0006I!a\u000e\t\rILB\u0011AA#\u0011\u001d\ty%\u0007C\u0001\u0003#Bq!!\u001a\u001a\t\u0003\t9\u0007C\u0005\u0002pe\t\t\u0011\"\u0001\u0002r!I\u0011\u0011P\r\u0012\u0002\u0013\u0005\u00111\u0010\u0005\n\u0003#K\u0012\u0013!C\u0001\u0003'C\u0011\"a&\u001a#\u0003%\t!!'\t\u0013\u0005u\u0015$!A\u0005B\u0005}\u0005\"CAY3\u0005\u0005I\u0011AAZ\u0011%\tY,GA\u0001\n\u0003\ti\fC\u0005\u0002Jf\t\t\u0011\"\u0001\u0002L\"I\u0011Q[\r\u0002\u0002\u0013\u0005\u0013q\u001b\u0005\n\u00037L\u0012\u0011!C!\u0003;D\u0011\"a8\u001a\u0003\u0003%\t%!9\t\u0013\u0005\r\u0018$!A\u0005B\u0005\u0015x!\u0003B+\u0003\u0005\u0005\t\u0012\u0001B,\r!9\u0018!!A\t\u0002\te\u0003B\u0002:1\t\u0003\u0011\t\u0007C\u0005\u0002`B\n\t\u0011\"\u0012\u0002b\"I!1\b\u0019\u0002\u0002\u0013\u0005%1\r\u0005\n\u0005\u0003\u0002\u0014\u0011!CA\u0005WB\u0011Ba\u00131\u0003\u0003%IA!\u0014\u0007\r\t]\u0014\u0001\u0011B=\u0011)\u0011YH\u000eBK\u0002\u0013\u0005!Q\u0010\u0005\u000b\u0005\u000b3$\u0011#Q\u0001\n\t}\u0004B\u0002:7\t\u0003\u00119\tC\u0004\u0003\u000eZ\"\tAa$\t\u000f\t\u001df\u0007\"\u0001\u0003*\"I\u0011q\u000e\u001c\u0002\u0002\u0013\u0005!Q\u0016\u0005\n\u0003s2\u0014\u0013!C\u0001\u0005cC\u0011\"!(7\u0003\u0003%\t%a(\t\u0013\u0005Ef'!A\u0005\u0002\u0005M\u0006\"CA^m\u0005\u0005I\u0011\u0001B[\u0011%\tIMNA\u0001\n\u0003\u0011I\fC\u0005\u0002VZ\n\t\u0011\"\u0011\u0003>\"I\u00111\u001c\u001c\u0002\u0002\u0013\u0005\u0013Q\u001c\u0005\n\u0003?4\u0014\u0011!C!\u0003CD\u0011\"a97\u0003\u0003%\tE!1\b\u0013\t\u0015\u0017!!A\t\u0002\t\u001dg!\u0003B<\u0003\u0005\u0005\t\u0012\u0001Be\u0011\u0019\u0011x\t\"\u0001\u0003N\"I\u0011q\\$\u0002\u0002\u0013\u0015\u0013\u0011\u001d\u0005\n\u0005w9\u0015\u0011!CA\u0005\u001fD\u0011B!\u0011H\u0003\u0003%\tIa5\t\u0013\t-s)!A\u0005\n\t5c!\u00026^\u0001\te\u0007B\u0003Bn\u001b\n\u0005\t\u0015!\u0003\u0003^\"Q!\u0011^'\u0003\u0002\u0003\u0006IAa;\t\u0015\tMXJ!A!\u0002\u0013\u0011)\u0010\u0003\u0006\u0003|6\u0013\t\u0011)A\u0005\u0005{DaA]'\u0005\u0002\r-\u0001bBB\u0015\u001b\u0012\u000511\u0006\u0005\b\u0007\u0013kE\u0011BBF\u0011\u001d\u0019\u0019+\u0014C\u0005\u0007KCqaa,N\t\u0013\u0019\t\fC\u0004\u0004<6#Ia!0\t\u000f\rmW\n\"\u0003\u0004^\"911X'\u0005\n\r5\bbBB|\u001b\u0012%1\u0011 \u0005\b\t\u0003iE\u0011\u0002C\u0002\u0003ei\u0015-\u001b7c_b\u001cV\r^+qI\u0006$X\rU3sM>\u0014X.\u001a:\u000b\u0005y{\u0016AB7fi\"|GM\u0003\u0002aC\u0006!!.\\1q\u0015\t\u00117-A\u0003kC6,7O\u0003\u0002eK\u00061\u0011\r]1dQ\u0016T\u0011AZ\u0001\u0004_J<7\u0001\u0001\t\u0003S\u0006i\u0011!\u0018\u0002\u001a\u001b\u0006LGNY8y'\u0016$X\u000b\u001d3bi\u0016\u0004VM\u001d4pe6,'o\u0005\u0002\u0002YB\u0011Q\u000e]\u0007\u0002]*\tq.A\u0003tG\u0006d\u0017-\u0003\u0002r]\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u00015\u0003'5\u000b\u0017\u000e\u001c2pqV\u0003H-\u0019;f%\u0016\u001cX\u000f\u001c;\u0014\u0005\ra\u0017fA\u0002\u001a\t\t!R*Y5mE>DX\u000b\u001d3bi\u00164\u0015-\u001b7ve\u0016\u001cR!\u00077zwz\u0004\"A_\u0002\u000e\u0003\u0005\u0001\"!\u001c?\n\u0005ut'a\u0002)s_\u0012,8\r\u001e\t\u0004\u007f\u0006=a\u0002BA\u0001\u0003\u0017qA!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f9\u0017A\u0002\u001fs_>$h(C\u0001p\u0013\r\tiA\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t\"a\u0005\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0007\u00055a.A\u0005nC&d'm\u001c=JIV\u0011\u0011\u0011\u0004\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011qD0\u0002\t5\f\u0017\u000e\\\u0005\u0005\u0003G\tiBA\tV]B\f'o]3e\u001b\u0006LGNY8y\u0013\u0012\f!\"\\1jY\n|\u00070\u00133!\u0003%)\u0007pY3qi&|g.\u0006\u0002\u0002,A\u0019q0!\f\n\t\u0005=\u00121\u0003\u0002\n)\"\u0014xn^1cY\u0016\f!\"\u001a=dKB$\u0018n\u001c8!\u0003\u0015\u0001\u0018\r^2i+\t\t9\u0004E\u0003n\u0003s\ti$C\u0002\u0002<9\u0014aa\u00149uS>t\u0007\u0003BA\u000e\u0003\u007fIA!!\u0011\u0002\u001e\tYb+\u00197jI\u0006$X\rZ'bS2\u0014w\u000e\u001f)bi\u000eDwJ\u00196fGR\fa\u0001]1uG\"\u0004C\u0003CA$\u0003\u0013\nY%!\u0014\u0011\u0005iL\u0002bBA\u000bA\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003O\u0001\u0003\u0019AA\u0016\u0011\u001d\t\u0019\u0004\ta\u0001\u0003o\taAZ5mi\u0016\u0014H\u0003BA*\u0003C\u0002R!\\A\u001d\u0003+\u0002B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037z\u0016\u0001B2pe\u0016LA!a\u0018\u0002Z\tQ\u0001K]8qKJ$\u0018.Z:\t\u000f\u0005\r\u0014\u00051\u0001\u0002V\u0005!\u0012mY2faR\f'\r\\3Qe>\u0004XM\u001d;jKN\f\u0011#Y:NC&d'm\u001c=TKR,%O]8s+\t\tI\u0007\u0005\u0003\u0002X\u0005-\u0014\u0002BA7\u00033\u0012\u0001bU3u\u000bJ\u0014xN]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002H\u0005M\u0014QOA<\u0011%\t)b\tI\u0001\u0002\u0004\tI\u0002C\u0005\u0002(\r\u0002\n\u00111\u0001\u0002,!I\u00111G\u0012\u0011\u0002\u0003\u0007\u0011qG\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiH\u000b\u0003\u0002\u001a\u0005}4FAAA!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-e.\u0001\u0006b]:|G/\u0019;j_:LA!a$\u0002\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u0013\u0016\u0005\u0003W\ty(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m%\u0006BA\u001c\u0003\u007f\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAQ!\u0011\t\u0019+!,\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bA\u0001\\1oO*\u0011\u00111V\u0001\u0005U\u00064\u0018-\u0003\u0003\u00020\u0006\u0015&AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00026B\u0019Q.a.\n\u0007\u0005efNA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002@\u0006\u0015\u0007cA7\u0002B&\u0019\u00111\u00198\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002H&\n\t\u00111\u0001\u00026\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\r\fg.R9vC2$B!!4\u0002TB\u0019Q.a4\n\u0007\u0005EgNA\u0004C_>dW-\u00198\t\u0013\u0005\u001d'&!AA\u0002\u0005}\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!)\u0002Z\"I\u0011qY\u0016\u0002\u0002\u0003\u0007\u0011QW\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QW\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011U\u0001\u0007KF,\u0018\r\\:\u0015\t\u00055\u0017q\u001d\u0005\n\u0003\u000ft\u0013\u0011!a\u0001\u0003\u007f\u0013A#T1jY\n|\u00070\u00169eCR,7+^2dKN\u001c8#\u0002\u0003msntXCAAx!\u0011\t\t0a?\u000e\u0005\u0005M(\u0002BA{\u0003o\fQ!\\8eK2T1!!?b\u0003\u001di\u0017-\u001b7c_bLA!!@\u0002t\nIQ*Y5mE>D\u0018\n\u001a\u000b\u0005\u0005\u0003\u0011\u0019\u0001\u0005\u0002{\t!9\u0011QC\u0004A\u0002\u0005=H\u0003\u0002B\u0001\u0005\u000fA\u0011\"!\u0006\t!\u0003\u0005\r!a<\u0016\u0005\t-!\u0006BAx\u0003\u007f\"B!a0\u0003\u0010!I\u0011q\u0019\u0007\u0002\u0002\u0003\u0007\u0011Q\u0017\u000b\u0005\u0003\u001b\u0014\u0019\u0002C\u0005\u0002H6\t\t\u00111\u0001\u0002@R!\u0011\u0011\u0015B\f\u0011%\t9MDA\u0001\u0002\u0004\t)\f\u0006\u0003\u0002N\nm\u0001\"CAd#\u0005\u0005\t\u0019AA`\u0003Qi\u0015-\u001b7c_b,\u0006\u000fZ1uKN+8mY3tgB\u0011!pE\n\u0006'\t\r\"q\u0006\t\t\u0005K\u0011Y#a<\u0003\u00025\u0011!q\u0005\u0006\u0004\u0005Sq\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005[\u00119CA\tBEN$(/Y2u\rVt7\r^5p]F\u0002BA!\r\u000385\u0011!1\u0007\u0006\u0005\u0005k\tI+\u0001\u0002j_&!\u0011\u0011\u0003B\u001a)\t\u0011y\"A\u0003baBd\u0017\u0010\u0006\u0003\u0003\u0002\t}\u0002bBA\u000b-\u0001\u0007\u0011q^\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)Ea\u0012\u0011\u000b5\fI$a<\t\u0013\t%s#!AA\u0002\t\u0005\u0011a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\n\t\u0005\u0003G\u0013\t&\u0003\u0003\u0003T\u0005\u0015&AB(cU\u0016\u001cG/\u0001\u000bNC&d'm\u001c=Va\u0012\fG/\u001a$bS2,(/\u001a\t\u0003uB\u001aR\u0001\rB.\u0005_\u0001BB!\n\u0003^\u0005e\u00111FA\u001c\u0003\u000fJAAa\u0018\u0003(\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0015\u0005\t]C\u0003CA$\u0005K\u00129G!\u001b\t\u000f\u0005U1\u00071\u0001\u0002\u001a!9\u0011qE\u001aA\u0002\u0005-\u0002bBA\u001ag\u0001\u0007\u0011q\u0007\u000b\u0005\u0005[\u0012)\bE\u0003n\u0003s\u0011y\u0007E\u0005n\u0005c\nI\"a\u000b\u00028%\u0019!1\u000f8\u0003\rQ+\b\u000f\\34\u0011%\u0011I\u0005NA\u0001\u0002\u0004\t9E\u0001\u000bNC&d'm\u001c=Va\u0012\fG/\u001a*fgVdGo]\n\u0005m1\\h0A\u0004sKN,H\u000e^:\u0016\u0005\t}\u0004\u0003B@\u0003\u0002fLAAa!\u0002\u0014\t\u00191+Z9\u0002\u0011I,7/\u001e7ug\u0002\"BA!#\u0003\fB\u0011!P\u000e\u0005\b\u0005wJ\u0004\u0019\u0001B@\u0003\u001d)\b\u000fZ1uK\u0012,\"A!%\u0011\u0011\tM%1TAx\u0005CsAA!&\u0003\u0018B\u0019\u00111\u00018\n\u0007\tee.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005;\u0013yJA\u0002NCBT1A!'o!\u0011\tYBa)\n\t\t\u0015\u0016Q\u0004\u0002\u0016\u001b\u0006LGNY8y+B$\u0017\r^3SKN\u0004xN\\:f\u0003)qw\u000e^+qI\u0006$X\rZ\u000b\u0003\u0005W\u0003\u0002Ba%\u0003\u001c\u0006e\u0011\u0011\u000e\u000b\u0005\u0005\u0013\u0013y\u000bC\u0005\u0003|q\u0002\n\u00111\u0001\u0003\u0000U\u0011!1\u0017\u0016\u0005\u0005\u007f\ny\b\u0006\u0003\u0002@\n]\u0006\"CAd\u0001\u0006\u0005\t\u0019AA[)\u0011\tiMa/\t\u0013\u0005\u001d\u0017)!AA\u0002\u0005}F\u0003BAQ\u0005\u007fC\u0011\"a2C\u0003\u0003\u0005\r!!.\u0015\t\u00055'1\u0019\u0005\n\u0003\u000f,\u0015\u0011!a\u0001\u0003\u007f\u000bA#T1jY\n|\u00070\u00169eCR,'+Z:vYR\u001c\bC\u0001>H'\u00159%1\u001aB\u0018!!\u0011)Ca\u000b\u0003\u0000\t%EC\u0001Bd)\u0011\u0011II!5\t\u000f\tm$\n1\u0001\u0003\u0000Q!!Q\u001bBl!\u0015i\u0017\u0011\bB@\u0011%\u0011IeSA\u0001\u0002\u0004\u0011Ii\u0005\u0002NY\u0006Q1/\u001a:jC2L'0\u001a:\u0011\t\t}'Q]\u0007\u0003\u0005CT1Aa9`\u0003\u0011Q7o\u001c8\n\t\t\u001d(\u0011\u001d\u0002\u0012\u001b\u0006LGNY8y'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018AD7bS2\u0014w\u000e_'b]\u0006<WM\u001d\t\u0005\u0005[\u0014y/\u0004\u0002\u0002x&!!\u0011_A|\u00059i\u0015-\u001b7c_bl\u0015M\\1hKJ\f1c];cg\u000e\u0014\u0018\u000e\u001d;j_:l\u0015M\\1hKJ\u0004BA!<\u0003x&!!\u0011`A|\u0005M\u0019VOY:de&\u0004H/[8o\u001b\u0006t\u0017mZ3s\u0003Ai\u0017-\u001b7c_bLEMR1di>\u0014\u0018\u0010\u0005\u0003\u0003\u0000\u000e\u0015a\u0002BAy\u0007\u0003IAaa\u0001\u0002t\u0006IQ*Y5mE>D\u0018\nZ\u0005\u0005\u0007\u000f\u0019IAA\u0004GC\u000e$xN]=\u000b\t\r\r\u00111\u001f\u000b\u000b\u0007\u001b\u0019ya!\u0005\u0004\u0014\rU\u0001CA5N\u0011\u001d\u0011YN\u0015a\u0001\u0005;DqA!;S\u0001\u0004\u0011Y\u000fC\u0004\u0003tJ\u0003\rA!>\t\u000f\tm(\u000b1\u0001\u0003~\"\u001a!k!\u0007\u0011\t\rm1QE\u0007\u0003\u0007;QAaa\b\u0004\"\u00051\u0011N\u001c6fGRT!aa\t\u0002\u000b)\fg/\u0019=\n\t\r\u001d2Q\u0004\u0002\u0007\u0013:TWm\u0019;\u0002\u001fU\u0004H-\u0019;f\u001b\u0006LGNY8yKN$\u0002b!\f\u0004Z\r\r4Q\u000e\t\u0007\u0007_\u0019id!\u0011\u000e\u0005\rE\"\u0002BB\u001a\u0007k\t\u0011\u0002];cY&\u001c\b.\u001a:\u000b\u0007=\u001c9D\u0003\u0003\u0002\\\re\"BAB\u001e\u0003\u001d\u0011X-Y2u_JLAaa\u0010\u00042\t)1+T8o_B\u001911\t\u001c\u000f\u0007\r\u0015\u0003A\u0004\u0003\u0004H\r]c\u0002BB%\u0007+rAaa\u0013\u0004T9!1QJB)\u001d\u0011\t\u0019aa\u0014\n\u0003\u0019L!\u0001Z3\n\u0005\t\u001c\u0017B\u00011b\u0013\tqv\fC\u0004\u0004\\M\u0003\ra!\u0018\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!!Q^B0\u0013\u0011\u0019\t'a>\u0003\u001d5\u000b\u0017\u000e\u001c2pqN+7o]5p]\"91QM*A\u0002\r\u001d\u0014!E7bS2\u0014w\u000e_*fiJ+\u0017/^3tiB!\u00111DB5\u0013\u0011\u0019Y'!\b\u0003#5\u000b\u0017\u000e\u001c2pqN+GOU3rk\u0016\u001cH\u000fC\u0004\u0004pM\u0003\ra!\u001d\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\u0011\r\tM51OB<\u0013\u0011\u0019)Ha(\u0003\u0007M+G\u000f\u0005\u0003\u0004z\r\re\u0002BB>\u0007\u007frAaa\u0012\u0004~%\u0019\u00111L0\n\t\r\u0005\u0015\u0011L\u0001\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\n\t\r\u00155q\u0011\u0002\u0015\u0007\u0006\u0004\u0018MY5mSRL\u0018\nZ3oi&4\u0017.\u001a:\u000b\t\r\u0005\u0015\u0011L\u0001\u000ekB$\u0017\r^3NC&d'm\u001c=\u0015\u0019\r55\u0011SBJ\u0007+\u001bIj!)\u0011\r\r=2QHBH!\r\u0019\u0019e\u0001\u0005\b\u00077\"\u0006\u0019AB/\u0011\u001d\t)\u0002\u0016a\u0001\u0003_Dqaa&U\u0001\u0004\tI\"A\tv]B\f'o]3e\u001b\u0006LGNY8y\u0013\u0012Dq!a\rU\u0001\u0004\u0019Y\n\u0005\u0003\u0002\u001c\ru\u0015\u0002BBP\u0003;\u0011!#T1jY\n|\u0007\u0010U1uG\"|%M[3di\"91q\u000e+A\u0002\rE\u0014AE;qI\u0006$XmU;cg\u000e\u0014\u0018\u000e\u001d;j_:$\u0002b!$\u0004(\u000e%6Q\u0016\u0005\b\u0003+)\u0006\u0019AAx\u0011\u001d\u0019Y+\u0016a\u0001\u0003{\taB^1mS\u0012\fG/\u001a3QCR\u001c\u0007\u000eC\u0004\u0004\\U\u0003\ra!\u0018\u0002#U\u0004H-\u0019;f\u001b\u0006LGNY8y!\u0006$\b\u000e\u0006\u0006\u0004\u000e\u000eM6QWB\\\u0007sCq!!\u0006W\u0001\u0004\ty\u000fC\u0004\u0004\u0018Z\u0003\r!!\u0007\t\u000f\r-f\u000b1\u0001\u0002>!911\f,A\u0002\ru\u0013aE1qa2L\b+\u0019:f]RLE-\u00169eCR,G\u0003CB`\u0007\u0017\u001cim!7\u0011\u000f5\u001c\tm!2\u0004F&\u001911\u00198\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BAy\u0007\u000fLAa!3\u0002t\nYQ*Y5mE>D\b+\u0019;i\u0011\u001d\t)b\u0016a\u0001\u0003_Dqaa4X\u0001\u0004\u0019\t.A\nnCf\u0014W\rU1sK:$\u0018\nZ+qI\u0006$X\rE\u0003n\u0003s\u0019\u0019\u000e\u0005\u0003\u0002\u001c\rU\u0017\u0002BBl\u0003;\u0011a\u0002U1sK:$\u0018\nZ+qI\u0006$X\rC\u0004\u0004\\]\u0003\ra!\u0018\u0002\u001f\u0005\u0004\b\u000f\\=OC6,W\u000b\u001d3bi\u0016$baa0\u0004`\u000e-\bbBBq1\u0002\u000711]\u0001\u0010[\u0006L(-\u001a(b[\u0016,\u0006\u000fZ1uKB)Q.!\u000f\u0004fB!\u00111DBt\u0013\u0011\u0019I/!\b\u0003\u00159\u000bW.Z+qI\u0006$X\rC\u0004\u0004\\a\u0003\ra!\u0018\u0015\u0011\r}6q^By\u0007kDq!!\u0006Z\u0001\u0004\ty\u000fC\u0004\u0004tf\u0003\raa5\u0002\u001dA\f'/\u001a8u\u0013\u0012,\u0006\u000fZ1uK\"911L-A\u0002\ru\u0013aE;qI\u0006$X-T1jY\n|\u0007PU5hQR\u001cH\u0003CBG\u0007w\u001cipa@\t\u000f\u0005U!\f1\u0001\u0002p\"911\u0016.A\u0002\u0005u\u0002bBB.5\u0002\u00071QL\u0001\u0011SN\f5+_:uK6l\u0015-\u001b7c_b$B!!4\u0005\u0006!9\u0011\u0011`.A\u0002\u0011\u001d\u0001\u0003\u0002Bw\t\u0013IA\u0001b\u0003\u0002x\nqQ*Z:tC\u001e,W*\u00198bO\u0016\u0014\b")
public class MailboxSetUpdatePerformer {
    private final MailboxSerializer serializer;
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;
    private final MailboxId.Factory mailboxIdFactory;

    public SMono<MailboxUpdateResults> updateMailboxes(MailboxSession mailboxSession, MailboxSetRequest mailboxSetRequest, Set<Refined<String, string.Uri>> capabilities) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)mailboxSetRequest.update().getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedMailboxId unparsedMailboxId = (UnparsedMailboxId)tuple2._1();
                MailboxPatchObject patch = (MailboxPatchObject)tuple2._2();
                if (unparsedMailboxId != null) {
                    UnparsedMailboxId unparsedMailboxId2 = unparsedMailboxId;
                    if (patch != null) {
                        MailboxPatchObject mailboxPatchObject = patch;
                        return ((SMono)MailboxGet$.MODULE$.parse($this.mailboxIdFactory, unparsedMailboxId2).fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)), (Function1 & Serializable)mailboxId -> this.updateMailbox(mailboxSession, (MailboxId)mailboxId, unparsedMailboxId2, mailboxPatchObject, capabilities))).onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new MailboxUpdateFailure(unparsedMailboxId2, (Throwable)e, (Option<ValidatedMailboxPatchObject>)None$.MODULE$)));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)MailboxSetUpdatePerformer$MailboxUpdateResults$.MODULE$);
    }

    private SMono<MailboxUpdateResult> updateMailbox(MailboxSession mailboxSession, MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, MailboxPatchObject patch, Set<Refined<String, string.Uri>> capabilities) {
        return (SMono)patch.validate(this.mailboxIdFactory, this.serializer, capabilities, mailboxSession).fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)validatedPatch -> this.updateMailboxRights(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession).then(this.updateSubscription(mailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)).then(this.updateMailboxPath(mailboxId, unparsedMailboxId, (ValidatedMailboxPatchObject)validatedPatch, mailboxSession)));
    }

    private SMono<MailboxUpdateResult> updateSubscription(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        return (SMono)validatedPatch.isSubscribedUpdate().map((Function1 & Serializable)isSubscribedUpdate -> SMono$.MODULE$.fromCallable(() -> {
            MailboxSetUpdatePerformer.$anonfun$updateSubscription$2(this, mailboxId, mailboxSession, isSubscribedUpdate);
            return BoxedUnit.UNIT;
        }).then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(Schedulers.elastic())).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId)));
    }

    private SMono<MailboxUpdateResult> updateMailboxPath(MailboxId mailboxId, UnparsedMailboxId unparsedMailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        if (validatedPatch.shouldUpdateMailboxPath()) {
            return SMono$.MODULE$.fromCallable(() -> {
                Product product;
                try {
                    MailboxPath newPath;
                    MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId, mailboxSession);
                    if (this.isASystemMailbox(mailbox)) {
                        throw new SystemMailboxChangeException(mailboxId);
                    }
                    if (validatedPatch.parentIdUpdate().flatMap((Function1 & Serializable)x$3 -> x$3.newId()).contains((Object)mailboxId)) {
                        throw new LoopInMailboxGraphException(mailboxId);
                    }
                    MailboxPath oldPath = mailbox.getMailboxPath();
                    Object object = !oldPath.equals((Object)(newPath = (MailboxPath)this.applyParentIdUpdate(mailboxId, validatedPatch.parentIdUpdate(), mailboxSession).andThen(this.applyNameUpdate(validatedPatch.nameUpdate(), mailboxSession)).apply((Object)oldPath))) ? $this.mailboxManager.renameMailbox(mailboxId, newPath, MailboxManager.RenameOption.RENAME_SUBSCRIPTIONS, mailboxSession) : BoxedUnit.UNIT;
                    product = new MailboxUpdateSuccess(mailboxId);
                }
                catch (Exception e) {
                    product = new MailboxUpdateFailure(unparsedMailboxId, e, (Option<ValidatedMailboxPatchObject>)new Some((Object)validatedPatch));
                }
                return product;
            }).subscribeOn(Schedulers.elastic());
        }
        return SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId));
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, Option<ParentIdUpdate> maybeParentIdUpdate, MailboxSession mailboxSession) {
        return (Function1)maybeParentIdUpdate.map((Function1 & Serializable)parentIdUpdate -> this.applyParentIdUpdate(mailboxId, (ParentIdUpdate)parentIdUpdate, mailboxSession)).getOrElse((Function0 & Serializable)() -> (Function1 & Serializable)x -> x);
    }

    private Function1<MailboxPath, MailboxPath> applyNameUpdate(Option<NameUpdate> maybeNameUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> (MailboxPath)maybeNameUpdate.map((Function1 & Serializable)nameUpdate -> {
            Option originalParentPath = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(originalPath.getHierarchyLevels(mailboxSession.getPathDelimiter())).asScala().reverse()).drop(1)).headOption();
            return (MailboxPath)originalParentPath.map((Function1 & Serializable)x$4 -> x$4.child(nameUpdate.newName(), mailboxSession.getPathDelimiter())).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)mailboxSession.getUser(), (String)nameUpdate.newName()));
        }).getOrElse((Function0 & Serializable)() -> originalPath);
    }

    private Function1<MailboxPath, MailboxPath> applyParentIdUpdate(MailboxId mailboxId, ParentIdUpdate parentIdUpdate, MailboxSession mailboxSession) {
        return (Function1 & Serializable)originalPath -> {
            String currentName = originalPath.getName(mailboxSession.getPathDelimiter());
            return (MailboxPath)parentIdUpdate.newId().map((Function1 & Serializable)id -> {
                Duration x$1;
                SMono qual$1 = SFlux$.MODULE$.fromPublisher((Publisher)$this.mailboxManager.search(MailboxQuery.builder().userAndNamespaceFrom(originalPath).expression((MailboxNameExpression)new PrefixedWildcard(new StringBuilder(0).append(originalPath.getName()).append(mailboxSession.getPathDelimiter()).toString())).build(), MailboxManager.MailboxSearchFetchType.Minimal, mailboxSession)).filter((Function1 & Serializable)child -> BoxesRunTime.boxToBoolean((boolean)MailboxSetUpdatePerformer.$anonfun$applyParentIdUpdate$6(id, child))).hasElements();
                boolean createsALoop = BoxesRunTime.unboxToBoolean((Object)qual$1.block(x$1 = qual$1.block$default$1()));
                if (createsALoop) {
                    throw new LoopInMailboxGraphException(mailboxId);
                }
                MailboxPath parentPath = $this.mailboxManager.getMailbox(id, mailboxSession).getMailboxPath();
                return parentPath.child(currentName, mailboxSession.getPathDelimiter());
            }).getOrElse((Function0 & Serializable)() -> MailboxPath.forUser((Username)originalPath.getUser(), (String)currentName));
        };
    }

    private SMono<MailboxUpdateResult> updateMailboxRights(MailboxId mailboxId, ValidatedMailboxPatchObject validatedPatch, MailboxSession mailboxSession) {
        SMono resetOperation = (SMono)validatedPatch.rightsReset().map((Function1 & Serializable)sharedWithResetUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.setRights(mailboxId, sharedWithResetUpdate.rights().toMailboxAcl().asJava(), mailboxSession);
            return BoxedUnit.UNIT;
        }).then()).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty());
        SFlux qual$1 = SFlux$.MODULE$.fromIterable(validatedPatch.rightsPartialUpdates());
        Function1 & Serializable x$1 = (Function1 & Serializable)partialUpdate -> SMono$.MODULE$.fromCallable(() -> {
            this.mailboxManager.applyRightsCommand(mailboxId, partialUpdate.asACLCommand(), mailboxSession);
            return BoxedUnit.UNIT;
        });
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        SMono partialUpdatesOperation = qual$1.flatMap((Function1)x$1, 5, x$3, x$4).then();
        return SFlux$.MODULE$.merge((Seq)new .colon.colon((Object)resetOperation, (List)new .colon.colon((Object)partialUpdatesOperation, (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).then().then(SMono$.MODULE$.just((Object)new MailboxUpdateSuccess(mailboxId))).subscribeOn(Schedulers.elastic());
    }

    private boolean isASystemMailbox(MessageManager mailbox) {
        return Role.from((String)mailbox.getMailboxPath().getName()).isPresent();
    }

    public static final /* synthetic */ void $anonfun$updateSubscription$2(MailboxSetUpdatePerformer $this, MailboxId mailboxId$2, MailboxSession mailboxSession$3, IsSubscribedUpdate isSubscribedUpdate$1) {
        MessageManager mailbox = $this.mailboxManager.getMailbox(mailboxId$2, mailboxSession$3);
        boolean isOwner = mailbox.getMailboxPath().belongsTo(mailboxSession$3);
        boolean shouldSubscribe = BoxesRunTime.unboxToBoolean((Object)isSubscribedUpdate$1.isSubscribed().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)((IsSubscribed)x$2).value())).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> isOwner));
        if (shouldSubscribe) {
            $this.subscriptionManager.subscribe(mailboxSession$3, mailbox.getMailboxPath().getName());
            return;
        }
        $this.subscriptionManager.unsubscribe(mailboxSession$3, mailbox.getMailboxPath().getName());
    }

    public static final /* synthetic */ boolean $anonfun$applyParentIdUpdate$6(MailboxId id$1, MailboxMetaData child) {
        return child.getId().equals(id$1);
    }

    @Inject
    public MailboxSetUpdatePerformer(MailboxSerializer serializer, MailboxManager mailboxManager, SubscriptionManager subscriptionManager, MailboxId.Factory mailboxIdFactory) {
        this.serializer = serializer;
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
        this.mailboxIdFactory = mailboxIdFactory;
    }

    public static class MailboxUpdateFailure
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final UnparsedMailboxId mailboxId;
        private final Throwable exception;
        private final Option<ValidatedMailboxPatchObject> patch;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public UnparsedMailboxId mailboxId() {
            return this.mailboxId;
        }

        public Throwable exception() {
            return this.exception;
        }

        public Option<ValidatedMailboxPatchObject> patch() {
            return this.patch;
        }

        public Option<Properties> filter(Properties acceptableProperties) {
            return new Some(this.patch().map((Function1 & Serializable)x$1 -> x$1.updatedProperties().intersect(acceptableProperties)).getOrElse((Function0 & Serializable)() -> acceptableProperties));
        }

        public SetError asMailboxSetError() {
            Throwable throwable = this.exception();
            if (throwable instanceof MailboxNotFoundException) {
                MailboxNotFoundException mailboxNotFoundException = (MailboxNotFoundException)throwable;
                return SetError$.MODULE$.notFound(mailboxNotFoundException.getMessage());
            }
            if (throwable instanceof MailboxNameException) {
                MailboxNameException mailboxNameException = (MailboxNameException)throwable;
                return SetError$.MODULE$.invalidArguments(mailboxNameException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof MailboxExistsException) {
                MailboxExistsException mailboxExistsException = (MailboxExistsException)throwable;
                return SetError$.MODULE$.invalidArguments(mailboxExistsException.getMessage(), this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof UnsupportedPropertyUpdatedException) {
                UnsupportedPropertyUpdatedException unsupportedPropertyUpdatedException = (UnsupportedPropertyUpdatedException)throwable;
                return SetError$.MODULE$.invalidArguments(new StringBuilder(45).append(new Refined((Object)unsupportedPropertyUpdatedException.property())).append(" property do not exist thus cannot be updated").toString(), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)unsupportedPropertyUpdatedException.property())}))));
            }
            if (throwable instanceof InvalidUpdateException) {
                InvalidUpdateException invalidUpdateException = (InvalidUpdateException)throwable;
                return SetError$.MODULE$.invalidArguments(String.valueOf(invalidUpdateException.cause()), (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)invalidUpdateException.property())}))));
            }
            if (throwable instanceof ServerSetPropertyException) {
                ServerSetPropertyException serverSetPropertyException = (ServerSetPropertyException)throwable;
                return SetError$.MODULE$.invalidArguments("Can not modify server-set properties", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)serverSetPropertyException.property())}))));
            }
            if (throwable instanceof InvalidPropertyException) {
                InvalidPropertyException invalidPropertyException = (InvalidPropertyException)throwable;
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPropertyException.cause()));
            }
            if (throwable instanceof InvalidPatchException) {
                InvalidPatchException invalidPatchException = (InvalidPatchException)throwable;
                return SetError$.MODULE$.invalidPatch(String.valueOf(invalidPatchException.cause()));
            }
            if (throwable instanceof SystemMailboxChangeException) {
                return SetError$.MODULE$.invalidArguments("Invalid change to a system mailbox", this.filter(Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"name")).value())), new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof LoopInMailboxGraphException) {
                return SetError$.MODULE$.invalidArguments("A mailbox parentId property can not be set to itself or one of its child", (Option<Properties>)new Some((Object)Properties$.MODULE$.apply((Seq<Refined<String, boolean.Not<collection.Empty>>>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"parentId")).value()))}))));
            }
            if (throwable instanceof InsufficientRightsException) {
                return SetError$.MODULE$.invalidArguments("Invalid change to a delegated mailbox", SetError$.MODULE$.invalidArguments$default$2());
            }
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SetError$.MODULE$.invalidArguments(illegalArgumentException.getMessage(), (Option<Properties>)None$.MODULE$);
            }
            return SetError$.MODULE$.serverFail(this.exception().getMessage());
        }

        public MailboxUpdateFailure copy(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            return new MailboxUpdateFailure(mailboxId, exception, patch);
        }

        public UnparsedMailboxId copy$default$1() {
            return this.mailboxId();
        }

        public Throwable copy$default$2() {
            return this.exception();
        }

        public Option<ValidatedMailboxPatchObject> copy$default$3() {
            return this.patch();
        }

        public String productPrefix() {
            return "MailboxUpdateFailure";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
                case 1: {
                    return this.exception();
                }
                case 2: {
                    return this.patch();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateFailure;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
                case 1: {
                    return "exception";
                }
                case 2: {
                    return "patch";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateFailure)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)x$1;
            UnparsedMailboxId unparsedMailboxId = this.mailboxId();
            UnparsedMailboxId unparsedMailboxId2 = mailboxUpdateFailure.mailboxId();
            if (unparsedMailboxId == null) {
                if (unparsedMailboxId2 != null) {
                    return false;
                }
            } else if (!((Object)unparsedMailboxId).equals(unparsedMailboxId2)) return false;
            Throwable throwable = this.exception();
            Throwable throwable2 = mailboxUpdateFailure.exception();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            Option<ValidatedMailboxPatchObject> option = this.patch();
            Option<ValidatedMailboxPatchObject> option2 = mailboxUpdateFailure.patch();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!mailboxUpdateFailure.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateFailure(UnparsedMailboxId mailboxId, Throwable exception, Option<ValidatedMailboxPatchObject> patch) {
            this.mailboxId = mailboxId;
            this.exception = exception;
            this.patch = patch;
            Product.$init$((Product)this);
        }
    }

    public static interface MailboxUpdateResult {
    }

    public static class MailboxUpdateResults
    implements Product,
    Serializable {
        private final Seq<MailboxUpdateResult> results;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Seq<MailboxUpdateResult> results() {
            return this.results;
        }

        public Map<MailboxId, MailboxUpdateResponse> updated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateSuccess) {
                    MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateSuccess.mailboxId(), (Object)MailboxSetResponse$.MODULE$.empty()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Map<UnparsedMailboxId, SetError> notUpdated() {
            return ((IterableOnceOps)this.results().flatMap((Function1 & Serializable)result -> {
                MailboxUpdateResult mailboxUpdateResult = result;
                if (mailboxUpdateResult instanceof MailboxUpdateFailure) {
                    MailboxUpdateFailure mailboxUpdateFailure = (MailboxUpdateFailure)mailboxUpdateResult;
                    return new Some((Object)new Tuple2((Object)mailboxUpdateFailure.mailboxId(), (Object)mailboxUpdateFailure.asMailboxSetError()));
                }
                return None$.MODULE$;
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public MailboxUpdateResults copy(Seq<MailboxUpdateResult> results) {
            return new MailboxUpdateResults(results);
        }

        public Seq<MailboxUpdateResult> copy$default$1() {
            return this.results();
        }

        public String productPrefix() {
            return "MailboxUpdateResults";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.results();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateResults;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "results";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateResults)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateResults mailboxUpdateResults = (MailboxUpdateResults)x$1;
            Seq<MailboxUpdateResult> seq = this.results();
            Seq<MailboxUpdateResult> seq2 = mailboxUpdateResults.results();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!mailboxUpdateResults.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateResults(Seq<MailboxUpdateResult> results) {
            this.results = results;
            Product.$init$((Product)this);
        }
    }

    public static class MailboxUpdateSuccess
    implements MailboxUpdateResult,
    Product,
    Serializable {
        private final MailboxId mailboxId;

        public Iterator<Object> productIterator() {
            return Product.productIterator$((Product)this);
        }

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public MailboxId mailboxId() {
            return this.mailboxId;
        }

        public MailboxUpdateSuccess copy(MailboxId mailboxId) {
            return new MailboxUpdateSuccess(mailboxId);
        }

        public MailboxId copy$default$1() {
            return this.mailboxId();
        }

        public String productPrefix() {
            return "MailboxUpdateSuccess";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mailboxId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MailboxUpdateSuccess;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "mailboxId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MailboxUpdateSuccess)) return false;
            boolean bl = true;
            if (!bl) return false;
            MailboxUpdateSuccess mailboxUpdateSuccess = (MailboxUpdateSuccess)x$1;
            MailboxId mailboxId = this.mailboxId();
            MailboxId mailboxId2 = mailboxUpdateSuccess.mailboxId();
            if (mailboxId == null) {
                if (mailboxId2 != null) {
                    return false;
                }
            } else if (!mailboxId.equals(mailboxId2)) return false;
            if (!mailboxUpdateSuccess.canEqual(this)) return false;
            return true;
        }

        public MailboxUpdateSuccess(MailboxId mailboxId) {
            this.mailboxId = mailboxId;
            Product.$init$((Product)this);
        }
    }
}

