/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.task.Hostname;
import org.apache.james.task.MemoryWorkQueue;
import org.apache.james.task.SerialTaskManagerWorker;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskExecutionDetailsUpdater;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskNotFoundException;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class MemoryTaskManager
implements TaskManager {
    private static final Duration UPDATE_INFORMATION_POLLING_DURATION = Duration.ofSeconds(5L);
    private static final Duration AWAIT_POLLING_DURATION = Duration.ofMillis(500L);
    public static final Duration NOW = Duration.ZERO;
    private final Hostname hostname;
    private final WorkQueue workQueue;
    private final TaskManagerWorker worker;
    private final ConcurrentHashMap<TaskId, TaskExecutionDetails> idToExecutionDetails;

    @Inject
    public MemoryTaskManager(Hostname hostname) {
        this.hostname = hostname;
        this.idToExecutionDetails = new ConcurrentHashMap();
        this.worker = new SerialTaskManagerWorker(this.updater(), UPDATE_INFORMATION_POLLING_DURATION);
        this.workQueue = new MemoryWorkQueue(this.worker);
    }

    public TaskId submit(Task task) {
        TaskId taskId = TaskId.generateTaskId();
        TaskExecutionDetails executionDetails = TaskExecutionDetails.from((Task)task, (TaskId)taskId, (Hostname)this.hostname);
        this.idToExecutionDetails.put(taskId, executionDetails);
        this.workQueue.submit(new TaskWithId(taskId, task));
        return taskId;
    }

    public TaskExecutionDetails getExecutionDetails(TaskId id) {
        return Optional.ofNullable(this.idToExecutionDetails.get(id)).orElseThrow(TaskNotFoundException::new);
    }

    public List<TaskExecutionDetails> list() {
        return ImmutableList.copyOf(this.idToExecutionDetails.values());
    }

    public List<TaskExecutionDetails> list(TaskManager.Status status) {
        return ImmutableList.copyOf(this.tasksFiltered(status).values());
    }

    private Map<TaskId, TaskExecutionDetails> tasksFiltered(TaskManager.Status status) {
        return (Map)this.idToExecutionDetails.entrySet().stream().filter(details -> ((TaskExecutionDetails)details.getValue()).getStatus().equals((Object)status)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void cancel(TaskId id) {
        Optional.ofNullable(this.idToExecutionDetails.get(id)).ifPresent(details -> {
            this.updateDetails(id).accept(taskExecutionDetails -> taskExecutionDetails.cancelRequested(this.hostname));
            this.workQueue.cancel(id);
        });
    }

    public TaskExecutionDetails await(TaskId id, Duration timeout) throws TaskNotFoundException, TaskManager.ReachedTimeoutException {
        try {
            return (TaskExecutionDetails)Flux.interval((Duration)NOW, (Duration)AWAIT_POLLING_DURATION, (Scheduler)Schedulers.elastic()).map(ignored -> this.getExecutionDetails(id)).filter(details -> details.getStatus().isFinished()).blockFirst(timeout);
        }
        catch (IllegalStateException e) {
            throw new TaskManager.ReachedTimeoutException();
        }
    }

    @PreDestroy
    public void stop() {
        try {
            this.workQueue.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private DetailsUpdater updater() {
        return new DetailsUpdater(this::updateDetails, this.hostname);
    }

    private Consumer<TaskExecutionDetailsUpdater> updateDetails(TaskId taskId) {
        return updater -> {
            TaskExecutionDetails currentDetails = this.idToExecutionDetails.get(taskId);
            TaskExecutionDetails newDetails = updater.update(currentDetails);
            this.idToExecutionDetails.replace(taskId, newDetails);
        };
    }

    private static class DetailsUpdater
    implements TaskManagerWorker.Listener {
        private final TaskExecutionDetailsUpdaterFactory updaterFactory;
        private final Hostname hostname;

        DetailsUpdater(TaskExecutionDetailsUpdaterFactory updaterFactory, Hostname hostname) {
            this.updaterFactory = updaterFactory;
            this.hostname = hostname;
        }

        @Override
        public Publisher<Void> started(TaskId taskId) {
            return Mono.fromRunnable(() -> this.updaterFactory.apply(taskId).accept(details -> details.started(this.hostname)));
        }

        @Override
        public Publisher<Void> completed(TaskId taskId, Task.Result result, Optional<TaskExecutionDetails.AdditionalInformation> additionalInformation) {
            return Mono.fromRunnable(() -> this.updaterFactory.apply(taskId).accept(details -> details.completed(additionalInformation)));
        }

        @Override
        public Publisher<Void> failed(TaskId taskId, Optional<TaskExecutionDetails.AdditionalInformation> additionalInformation, String errorMessage, Throwable t) {
            return this.failed(taskId, additionalInformation);
        }

        @Override
        public Publisher<Void> failed(TaskId taskId, Optional<TaskExecutionDetails.AdditionalInformation> additionalInformation, Throwable t) {
            return this.failed(taskId, additionalInformation);
        }

        @Override
        public Publisher<Void> failed(TaskId taskId, Optional<TaskExecutionDetails.AdditionalInformation> additionalInformation) {
            return Mono.fromRunnable(() -> this.updaterFactory.apply(taskId).accept(details -> details.failed(additionalInformation)));
        }

        @Override
        public Publisher<Void> cancelled(TaskId taskId, Optional<TaskExecutionDetails.AdditionalInformation> additionalInformation) {
            return Mono.fromRunnable(() -> this.updaterFactory.apply(taskId).accept(details -> details.cancelEffectively(additionalInformation)));
        }

        @Override
        public Publisher<Void> updated(TaskId taskId, TaskExecutionDetails.AdditionalInformation additionalInformation) {
            return Mono.empty();
        }
    }

    @FunctionalInterface
    private static interface TaskExecutionDetailsUpdaterFactory {
        public Consumer<TaskExecutionDetailsUpdater> apply(TaskId var1);
    }
}

