/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.james.jdkim.canon.SimpleBodyCanonicalizer;

public class RelaxedBodyCanonicalizer
extends FilterOutputStream {
    private boolean pendingSpaces = false;

    public RelaxedBodyCanonicalizer(OutputStream out) {
        super(new SimpleBodyCanonicalizer(out));
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        int start = off;
        int end = len + off;
        for (int k = off; k < end; ++k) {
            if (this.pendingSpaces) {
                if (buffer[k] == 32 || buffer[k] == 9) continue;
                if (buffer[k] != 13) {
                    this.out.write(32);
                }
                this.pendingSpaces = false;
                len = len - k + start;
                start = k;
                continue;
            }
            if (buffer[k] != 32 && buffer[k] != 9 || k + 1 < end && buffer[k] == 32 && buffer[k + 1] != 32 && buffer[k + 1] != 9 && buffer[k + 1] != 13) continue;
            this.out.write(buffer, start, k - start);
            this.pendingSpaces = true;
        }
        if (!this.pendingSpaces) {
            this.out.write(buffer, start, len);
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pendingSpaces) {
            if (b != 32 && b != 9) {
                if (b != 13) {
                    this.out.write(32);
                }
                this.pendingSpaces = false;
                this.out.write(b);
            }
        } else if (b == 32 || b == 9) {
            this.pendingSpaces = true;
        } else {
            this.out.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        this.complete();
        super.close();
    }

    private void complete() throws IOException {
        if (this.pendingSpaces) {
            this.out.write(32);
        }
    }
}

