/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mail;

import cats.Applicative;
import cats.implicits$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.boolean;
import eu.timepit.refined.numeric;
import java.io.Serializable;
import org.apache.james.jmap.mail.EmailBodyPart;
import org.apache.james.jmap.mail.EmailBodyValue;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailParseRequest;
import org.apache.james.jmap.mail.FetchAllBodyValues;
import org.apache.james.jmap.mail.FetchHTMLBodyValues;
import org.apache.james.jmap.mail.FetchTextBodyValues;
import org.apache.james.jmap.mail.PartId;
import org.apache.james.util.html.HtmlTextExtractor;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import shapeless._0;

public final class EmailFullViewFactory$ {
    public static final EmailFullViewFactory$ MODULE$ = new EmailFullViewFactory$();

    public Try<Map<PartId, EmailBodyValue>> extractBodyValues(HtmlTextExtractor htmlTextExtractor, EmailBodyPart bodyStructure, EmailGetRequest request) {
        return this.extractTextBodyValues(htmlTextExtractor, bodyStructure.textBody(), request.maxBodyValueBytes(), request.fetchTextBodyValues().exists((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)((FetchTextBodyValues)x$21).value()))).flatMap((Function1 & Serializable)textBodyValues -> MODULE$.extractBodyValues(bodyStructure.htmlBody(), request.maxBodyValueBytes(), request.fetchHTMLBodyValues().exists((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)((FetchHTMLBodyValues)x$22).value()))).flatMap((Function1 & Serializable)htmlBodyValues -> MODULE$.extractBodyValues(bodyStructure.flatten(), request.maxBodyValueBytes(), request.fetchAllBodyValues().exists((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)((FetchAllBodyValues)x$23).value()))).map((Function1 & Serializable)allBodyValues -> ((IterableOnceOps)((StrictOptimizedSeqOps)((IterableOps)textBodyValues.$plus$plus((IterableOnce)htmlBodyValues)).$plus$plus((IterableOnce)allBodyValues)).distinctBy((Function1 & Serializable)x$24 -> (PartId)x$24._1())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    public Try<Map<PartId, EmailBodyValue>> extractBodyValuesForParse(HtmlTextExtractor htmlTextExtractor, EmailBodyPart bodyStructure, EmailParseRequest request) {
        return this.extractTextBodyValues(htmlTextExtractor, bodyStructure.textBody(), request.maxBodyValueBytes(), request.fetchTextBodyValues().exists((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)((FetchTextBodyValues)x$25).value()))).flatMap((Function1 & Serializable)textBodyValues -> MODULE$.extractBodyValues(bodyStructure.htmlBody(), request.maxBodyValueBytes(), request.fetchHTMLBodyValues().exists((Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)((FetchHTMLBodyValues)x$26).value()))).flatMap((Function1 & Serializable)htmlBodyValues -> MODULE$.extractBodyValues(bodyStructure.flatten(), request.maxBodyValueBytes(), request.fetchAllBodyValues().exists((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)((FetchAllBodyValues)x$27).value()))).map((Function1 & Serializable)allBodyValues -> ((IterableOnceOps)((StrictOptimizedSeqOps)((IterableOps)textBodyValues.$plus$plus((IterableOnce)htmlBodyValues)).$plus$plus((IterableOnce)allBodyValues)).distinctBy((Function1 & Serializable)x$28 -> (PartId)x$28._1())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))));
    }

    private Try<List<Tuple2<PartId, EmailBodyValue>>> extractBodyValues(List<EmailBodyPart> parts, Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> maxBodyBytes, boolean shouldFetch) {
        if (shouldFetch) {
            return ((Try)implicits$.MODULE$.toTraverseOps((Object)parts.map((Function1 & Serializable)part -> part.bodyContent().map((Function1 & Serializable)bodyValue -> bodyValue.map((Function1 & Serializable)b -> new Tuple2((Object)part.partId(), (Object)b.truncate(maxBodyBytes))))), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForTry())).map((Function1 & Serializable)list -> (List)list.flatten(Predef$.MODULE$.$conforms()));
        }
        return new Success((Object)Nil$.MODULE$);
    }

    private Try<List<Tuple2<PartId, EmailBodyValue>>> extractTextBodyValues(HtmlTextExtractor htmlTextExtractor, List<EmailBodyPart> parts, Option<Refined<Object, boolean.Not<numeric.Less<_0>>>> maxBodyBytes, boolean shouldFetch) {
        if (shouldFetch) {
            return ((Try)implicits$.MODULE$.toTraverseOps((Object)parts.map((Function1 & Serializable)part -> part.textBodyContent(htmlTextExtractor).map((Function1 & Serializable)bodyValue -> bodyValue.map((Function1 & Serializable)b -> new Tuple2((Object)part.partId(), (Object)b.truncate(maxBodyBytes))))), implicits$.MODULE$.catsStdInstancesForList()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)implicits$.MODULE$.catsStdInstancesForTry())).map((Function1 & Serializable)list -> (List)list.flatten(Predef$.MODULE$.$conforms()));
        }
        return new Success((Object)Nil$.MODULE$);
    }

    private EmailFullViewFactory$() {
    }
}

