/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.JMAPServer;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.Session;
import org.apache.james.jmap.core.UrlPrefixes$;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.metrics.HttpClientMetrics;
import org.apache.james.jmap.routes.SessionRoutes$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.user.api.DelegationStore;
import org.reactivestreams.Publisher;
import play.api.libs.json.Json$;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t]q!B\u0010!\u0011\u0003Yc!B\u0017!\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%I\u0001\u000f\u0005\u0007\t\u0006\u0001\u000b\u0011B\u001d\t\u000f\u0015\u000b!\u0019!C\u0005q!1a)\u0001Q\u0001\neBqaR\u0001C\u0002\u0013%\u0001\n\u0003\u0004P\u0003\u0001\u0006I!\u0013\u0004\u0005[\u0001\u0002\u0001\u000b\u0003\u0005^\u0013\t\u0015\r\u0011\"\u0001_\u0011!)\u0017B!A!\u0002\u0013y\u0006\u0002\u00034\n\u0005\u000b\u0007I\u0011A4\t\u0011-L!\u0011!Q\u0001\n!D\u0001\u0002\\\u0005\u0003\u0006\u0004%\t!\u001c\u0005\tm&\u0011\t\u0011)A\u0005]\"Aq/\u0003BC\u0002\u0013\u0005\u0001\u0010\u0003\u0005\u0000\u0013\t\u0005\t\u0015!\u0003z\u0011)\t\t!\u0003BC\u0002\u0013\u0005\u00111\u0001\u0005\u000b\u0003#I!\u0011!Q\u0001\n\u0005\u0015\u0001BB\u001b\n\t\u0003\t\u0019\u0002C\u0005\u0002B%\u0011\r\u0011\"\u0003\u0002D!A\u00111K\u0005!\u0002\u0013\t)\u0005C\u0004\u0002V%!I!a\u0016\t\u0013\u0005}\u0013B1A\u0005\n\u0005\r\u0003\u0002CA1\u0013\u0001\u0006I!!\u0012\t\r\u0005JA\u0011IA2\u0011\u001d\tY(\u0003C\u0005\u0003{Bq!!,\n\t\u0013\ty\u000bC\u0004\u0002^&!I!a8\t\u000f\t\u0015\u0011\u0002\"\u0003\u0003\b\u0005i1+Z:tS>t'k\\;uKNT!!\t\u0012\u0002\rI|W\u000f^3t\u0015\t\u0019C%\u0001\u0003k[\u0006\u0004(BA\u0013'\u0003\u0015Q\u0017-\\3t\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001A\u0011A&A\u0007\u0002A\ti1+Z:tS>t'k\\;uKN\u001c\"!A\u0018\u0011\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t1&\u0001\u0007K\u001b\u0006\u0003vlU#T'&{e*F\u0001:!\tQ\u0014I\u0004\u0002<\u007fA\u0011A(M\u0007\u0002{)\u0011aHK\u0001\u0007yI|w\u000e\u001e \n\u0005\u0001\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u0019\u0002\u001b)k\u0015\tU0T\u000bN\u001b\u0016j\u0014(!\u0003=9V\t\u0014'`\u0017:{uKT0K\u001b\u0006\u0003\u0016\u0001E,F\u00192{6JT(X\u001d~SU*\u0011)!\u0003\u0019aujR$F%V\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002MQ\u0005)1\u000f\u001c45U&\u0011aj\u0013\u0002\u0007\u0019><w-\u001a:\u0002\u000f1{uiR#SAM\u0019\u0011\"U-\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016\u0001\u00027b]\u001eT\u0011AV\u0001\u0005U\u00064\u0018-\u0003\u0002Y'\n1qJ\u00196fGR\u0004\"AW.\u000e\u0003\tJ!\u0001\u0018\u0012\u0003\u0015)k\u0015\t\u0015*pkR,7/A\u0007bkRDWM\u001c;jG\u0006$xN]\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!MI\u0001\u0005QR$\b/\u0003\u0002eC\ni\u0011)\u001e;iK:$\u0018nY1u_J\fa\"Y;uQ\u0016tG/[2bi>\u0014\b%A\btKN\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005A\u0007C\u0001\u0017j\u0013\tQ\u0007EA\bTKN\u001c\u0018n\u001c8TkB\u0004H.[3s\u0003A\u0019Xm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\b%A\beK2,w-\u0019;j_:\u001cFo\u001c:f+\u0005q\u0007CA8u\u001b\u0005\u0001(BA9s\u0003\r\t\u0007/\u001b\u0006\u0003g\u0012\nA!^:fe&\u0011Q\u000f\u001d\u0002\u0010\t\u0016dWmZ1uS>t7\u000b^8sK\u0006\u0001B-\u001a7fO\u0006$\u0018n\u001c8Ti>\u0014X\rI\u0001\u0019U6\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>tW#A=\u0011\u0005ilX\"A>\u000b\u0005q\u0014\u0013\u0001B2pe\u0016L!A`>\u00031)k\u0017\r\u001d*gGb2$'M\"p]\u001aLw-\u001e:bi&|g.A\rk[\u0006\u0004(KZ29mI\n4i\u001c8gS\u001e,(/\u0019;j_:\u0004\u0013!\u00055uiB\u001cE.[3oi6+GO]5dgV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002\u0012\u0002\u000f5,GO]5dg&!\u0011qBA\u0005\u0005EAE\u000f\u001e9DY&,g\u000e^'fiJL7m]\u0001\u0013QR$\bo\u00117jK:$X*\u001a;sS\u000e\u001c\b\u0005\u0006\u0007\u0002\u0016\u0005]\u0011\u0011GA\u001a\u0003k\t9\u0004\u0005\u0002-\u0013!)Q\f\u0006a\u0001?\"B\u0011qCA\u000e\u0003W\ti\u0003\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\r%t'.Z2u\u0015\t\t)#A\u0004kC.\f'\u000f^1\n\t\u0005%\u0012q\u0004\u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003_\t\u0001B\u0015$D[a2$'\r\u0005\u0006MR\u0001\r\u0001\u001b\u0005\u0006YR\u0001\rA\u001c\u0005\u0006oR\u0001\r!\u001f\u0005\b\u0003\u0003!\u0002\u0019AA\u0003Q\r!\u00121\b\t\u0005\u0003;\ti$\u0003\u0003\u0002@\u0005}!AB%oU\u0016\u001cG/A\bhK:,'/\u0019;f'\u0016\u001c8/[8o+\t\t)\u0005\u0005\u0003\u0002H\u00055cb\u0001.\u0002J%\u0019\u00111\n\u0012\u0002\u0013)k\u0015\t\u0015*pkR,\u0017\u0002BA(\u0003#\u0012a!Q2uS>t'bAA&E\u0005\u0001r-\u001a8fe\u0006$XmU3tg&|g\u000eI\u0001 kB$\u0017\r^3IiR\u00048\t\\5f]RlU\r\u001e:jGNLeMT3fI\u0016$GCAA-!\r\u0001\u00141L\u0005\u0004\u0003;\n$\u0001B+oSR\f\u0011C]3eSJ,7\r\u001e+p'\u0016\u001c8/[8o\u0003I\u0011X\rZ5sK\u000e$Hk\\*fgNLwN\u001c\u0011\u0015\u0005\u0005\u0015\u0004CBA4\u0003c\n)(\u0004\u0002\u0002j)!\u00111NA7\u0003\u0019\u0019HO]3b[*\u0019\u0011qN+\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003g\nIG\u0001\u0004TiJ,\u0017-\u001c\t\u00045\u0006]\u0014bAA=E\tI!*T!Q%>,H/Z\u0001\u0012O\u0016$H)\u001a7fO\u0006$X\rZ+tKJ\u001cH\u0003BA@\u0003;\u0003b!!!\u0002\u0010\u0006MUBAAB\u0015\u0011\t))a\"\u0002\u0013A,(\r\\5tQ\u0016\u0014(b\u0001\u001a\u0002\n*\u0019A0a#\u000b\u0005\u00055\u0015a\u0002:fC\u000e$xN]\u0005\u0005\u0003#\u000b\u0019IA\u0003T\r2,\b\u0010\u0005\u0003\u0002\u0016\u0006eUBAAL\u0015\taH%\u0003\u0003\u0002\u001c\u0006]%\u0001C+tKJt\u0017-\\3\t\u000f\u0005}5\u00041\u0001\u0002\"\u0006qQ.Y5mE>D8+Z:tS>t\u0007\u0003BAR\u0003Sk!!!*\u000b\u0007\u0005\u001dF%A\u0004nC&d'm\u001c=\n\t\u0005-\u0016Q\u0015\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0003-\u0019XM\u001c3SKN\u0004xN\u001c3\u0015\r\u0005E\u0016QXAd!\u0019\t\t)a-\u00028&!\u0011QWAB\u0005\u0015\u0019Vj\u001c8p!\r\u0011\u0016\u0011X\u0005\u0004\u0003w\u001b&\u0001\u0002,pS\u0012Dq!a0\u001d\u0001\u0004\t\t-A\u0004tKN\u001c\u0018n\u001c8\u0011\u0007i\f\u0019-C\u0002\u0002Fn\u0014qaU3tg&|g\u000eC\u0004\u0002Jr\u0001\r!a3\u0002\tI,7\u000f\u001d\t\u0005\u0003\u001b\fI.\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003\u0019\u0019XM\u001d<fe*\u0019!-!6\u000b\t\u0005]\u00171R\u0001\u0006]\u0016$H/_\u0005\u0005\u00037\fyM\u0001\nIiR\u00048+\u001a:wKJ\u0014Vm\u001d9p]N,\u0017!D3se>\u0014\b*\u00198eY&tw\r\u0006\u0004\u0002b\u0006-(\u0011\u0001\t\u0007\u0003G\f9/a.\u000e\u0005\u0005\u0015(\u0002BAC\u0003\u0013KA!!;\u0002f\n!Qj\u001c8p\u0011\u001d\ti/\ba\u0001\u0003_\f\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t\u0005E\u00181 \b\u0005\u0003g\f9PD\u0002=\u0003kL\u0011AM\u0005\u0004\u0003s\f\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003{\fyPA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011`\u0019\t\u000f\t\rQ\u00041\u0001\u0002L\u0006A!/Z:q_:\u001cX-\u0001\bsKN\u0004xN\u001c3EKR\f\u0017\u000e\\:\u0015\r\u0005\u0005(\u0011\u0002B\u0007\u0011\u001d\u0011YA\ba\u0001\u0003\u0017\f!\u0003\u001b;uaN+'O^3s%\u0016\u001c\bo\u001c8tK\"9!q\u0002\u0010A\u0002\tE\u0011a\u00023fi\u0006LGn\u001d\t\u0004u\nM\u0011b\u0001B\u000bw\nq\u0001K]8cY\u0016lG)\u001a;bS2\u001c\b")
public class SessionRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final SessionSupplier sessionSupplier;
    private final DelegationStore delegationStore;
    private final JmapRfc8621Configuration jmapRfc8621Configuration;
    private final HttpClientMetrics httpClientMetrics;
    private final JMAPRoute.Action generateSession;
    private final JMAPRoute.Action redirectToSession;

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public DelegationStore delegationStore() {
        return this.delegationStore;
    }

    public JmapRfc8621Configuration jmapRfc8621Configuration() {
        return this.jmapRfc8621Configuration;
    }

    public HttpClientMetrics httpClientMetrics() {
        return this.httpClientMetrics;
    }

    private JMAPRoute.Action generateSession() {
        return this.generateSession;
    }

    private void updateHttpClientMetricsIfNeeded() {
        if (JMAPServer.REACTOR_NETTY_METRICS_ENABLE) {
            this.httpClientMetrics().update();
            return;
        }
    }

    private JMAPRoute.Action redirectToSession() {
        return this.redirectToSession;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(this.generateSession()).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.GET, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(this.redirectToSession()).corsHeaders(), JMAPRoute.builder().endpoint(Endpoint.ofFixedPath((HttpMethod)HttpMethod.OPTIONS, (String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$WELL_KNOWN_JMAP())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    private SFlux<Username> getDelegatedUsers(MailboxSession mailboxSession) {
        return SFlux$.MODULE$.apply(this.delegationStore().delegatedUsers((Username)OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(mailboxSession.getLoggedInUser())).getOrElse((Function0 & Serializable)() -> mailboxSession.getUser())));
    }

    private SMono<Void> sendRespond(Session session, HttpServerResponse resp) {
        return SMono$.MODULE$.fromCallable(() -> Json$.MODULE$.stringify(ResponseSerializer$.MODULE$.serialize(session))).map((Function1 & Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.apply((Publisher)resp.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json; charset=UTF-8").status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    private Mono<Void> errorHandling(Throwable throwable, HttpServerResponse response) {
        Throwable throwable2 = throwable;
        if (throwable2 instanceof UnauthorizedException) {
            UnauthorizedException unauthorizedException = (UnauthorizedException)throwable2;
            SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
            HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
            String x$2 = unauthorizedException.getMessage();
            String x$3 = ProblemDetails$.MODULE$.apply$default$1();
            Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
            return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$3, x$1, x$4, x$2));
        }
        SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$LOGGER().error("Unexpected error upon requesting session", throwable2);
        HttpResponseStatus x$5 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        String x$6 = throwable2.getMessage();
        String x$7 = ProblemDetails$.MODULE$.apply$default$1();
        Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
        return this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, x$6));
    }

    private Mono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$3 -> x$3.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then())).asJava();
    }

    @Inject
    public SessionRoutes(@Named(value="RFC-8621") Authenticator authenticator, SessionSupplier sessionSupplier, DelegationStore delegationStore, JmapRfc8621Configuration jmapRfc8621Configuration, HttpClientMetrics httpClientMetrics) {
        this.authenticator = authenticator;
        this.sessionSupplier = sessionSupplier;
        this.delegationStore = delegationStore;
        this.jmapRfc8621Configuration = jmapRfc8621Configuration;
        this.httpClientMetrics = httpClientMetrics;
        this.generateSession = (request, response) -> SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)mailboxSession -> this.getDelegatedUsers((MailboxSession)mailboxSession).collectSeq().map((Function1 & Serializable)seq -> Pair.of((Object)mailboxSession.getUser(), (Object)seq))).flatMap((Function1 & Serializable)baseUserAndDelegatedUsers -> this.sessionSupplier().generate((Username)baseUserAndDelegatedUsers.getLeft(), (Set<Username>)((IterableOnceOps)baseUserAndDelegatedUsers.getRight()).toSet(), UrlPrefixes$.MODULE$.from(this.jmapRfc8621Configuration(), request))).flatMap((Function1 & Serializable)session -> this.sendRespond((Session)session, response)).onErrorResume((Function1 & Serializable)throwable -> SMono$.MODULE$.fromPublisher(this.errorHandling((Throwable)throwable, response))).asJava().doOnSuccess(x$1 -> this.updateHttpClientMetricsIfNeeded());
        this.redirectToSession = JMAPRoutes.redirectTo((String)SessionRoutes$.MODULE$.org$apache$james$jmap$routes$SessionRoutes$$JMAP_SESSION());
    }
}

