/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.HeaderAndBodyByteContent;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.apache.james.mailbox.postgres.mail.MessageRepresentation;
import org.apache.james.mailbox.postgres.mail.PostgresAttachmentMapper;
import org.apache.james.mailbox.postgres.mail.PostgresMessageDataDefinition;
import org.apache.james.mailbox.postgres.mail.dto.AttachmentsDTO;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.jooq.Record;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresMessageRetriever {
    private final BlobStore blobStore;
    private final BlobId.Factory blobIdFactory;
    private final PostgresAttachmentMapper attachmentMapper;
    private final List<PartRetriever> partRetrievers = List.of(new AttachmentPartRetriever(), new BlobContentPartRetriever());

    public PostgresMessageRetriever(BlobStore blobStore, BlobId.Factory blobIdFactory, PostgresAttachmentMapper attachmentMapper) {
        this.blobStore = blobStore;
        this.blobIdFactory = blobIdFactory;
        this.attachmentMapper = attachmentMapper;
    }

    public Flux<MailboxMessage> get(MessageMapper.FetchType fetchType, Flux<Pair<SimpleMailboxMessage.Builder, Record>> initialFlux) {
        return Flux.fromIterable(this.partRetrievers).filter(partRetriever -> partRetriever.isApplicable(fetchType)).reduce(initialFlux, (flux, partRetriever) -> partRetriever.doRetrieve((Flux<Pair<SimpleMailboxMessage.Builder, Record>>)flux)).flatMapMany(flux -> flux).map(pair -> ((SimpleMailboxMessage.Builder)pair.getLeft()).build());
    }

    class AttachmentPartRetriever
    implements PartRetriever {
        AttachmentPartRetriever() {
        }

        @Override
        public boolean isApplicable(MessageMapper.FetchType fetchType) {
            return fetchType == MessageMapper.FetchType.FULL || fetchType == MessageMapper.FetchType.ATTACHMENTS_METADATA;
        }

        @Override
        public Flux<Pair<SimpleMailboxMessage.Builder, Record>> doRetrieve(Flux<Pair<SimpleMailboxMessage.Builder, Record>> chain) {
            return chain.collectList().flatMapMany(list -> Flux.fromIterable((Iterable)list).flatMapSequential(pair -> Mono.fromCallable(() -> this.toMap((AttachmentsDTO)((Record)pair.getRight()).get(PostgresMessageDataDefinition.MessageTable.ATTACHMENT_METADATA))).flatMap(this::getAttachments).map(messageAttachmentMetadata -> {
                ((SimpleMailboxMessage.Builder)pair.getLeft()).addAttachments((Collection)messageAttachmentMetadata);
                return pair;
            }).switchIfEmpty(Mono.just((Object)pair))));
        }

        private Map<AttachmentId, MessageRepresentation.AttachmentRepresentation> toMap(AttachmentsDTO attachmentRepresentations) {
            return (Map)attachmentRepresentations.stream().collect(ImmutableMap.toImmutableMap(MessageRepresentation.AttachmentRepresentation::getAttachmentId, obj -> obj));
        }

        private Mono<List<MessageAttachmentMetadata>> getAttachments(Map<AttachmentId, MessageRepresentation.AttachmentRepresentation> mapAttachmentIdToAttachmentRepresentation) {
            return Mono.fromCallable(mapAttachmentIdToAttachmentRepresentation::keySet).flatMapMany(PostgresMessageRetriever.this.attachmentMapper::getAttachmentsReactive).map(attachmentMetadata -> this.constructMessageAttachment((AttachmentMetadata)attachmentMetadata, (MessageRepresentation.AttachmentRepresentation)mapAttachmentIdToAttachmentRepresentation.get(attachmentMetadata.getAttachmentId()))).collectList();
        }

        private MessageAttachmentMetadata constructMessageAttachment(AttachmentMetadata attachment, MessageRepresentation.AttachmentRepresentation messageAttachmentRepresentation) {
            return MessageAttachmentMetadata.builder().attachment(attachment).name((String)messageAttachmentRepresentation.getName().orElse(null)).cid(messageAttachmentRepresentation.getCid()).isInline(Boolean.valueOf(messageAttachmentRepresentation.isInline())).build();
        }
    }

    class BlobContentPartRetriever
    implements PartRetriever {
        BlobContentPartRetriever() {
        }

        @Override
        public boolean isApplicable(MessageMapper.FetchType fetchType) {
            return fetchType == MessageMapper.FetchType.FULL;
        }

        @Override
        public Flux<Pair<SimpleMailboxMessage.Builder, Record>> doRetrieve(Flux<Pair<SimpleMailboxMessage.Builder, Record>> chain) {
            return chain.flatMapSequential(pair -> this.retrieveFullContent((Record)pair.getRight()).map(headerAndBodyContent -> Pair.of((Object)((SimpleMailboxMessage.Builder)pair.getLeft()).content(headerAndBodyContent), (Object)((Record)pair.getRight()))), 16);
        }

        private Mono<Content> retrieveFullContent(Record messageRecord) {
            return Mono.from((Publisher)PostgresMessageRetriever.this.blobStore.readBytes(PostgresMessageRetriever.this.blobStore.getDefaultBucketName(), PostgresMessageRetriever.this.blobIdFactory.parse((String)messageRecord.get(PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID)), BlobStore.StoragePolicy.SIZE_BASED)).map(bodyBytes -> new HeaderAndBodyByteContent((byte[])messageRecord.get(PostgresMessageDataDefinition.MessageTable.HEADER_CONTENT), bodyBytes));
        }
    }

    static interface PartRetriever {
        public boolean isApplicable(MessageMapper.FetchType var1);

        public Flux<Pair<SimpleMailboxMessage.Builder, Record>> doRetrieve(Flux<Pair<SimpleMailboxMessage.Builder, Record>> var1);
    }
}

