/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.apache.jena.atlas.io.CharStreamReader;
import org.apache.jena.atlas.io.IO;

public final class CharStreamBuffered
extends CharStreamReader {
    static final int CB_SIZE = 131072;
    private final char[] chars;
    private int buffLen = 0;
    private int idx = 0;
    private final Source source;
    private long total = 0L;

    public CharStreamBuffered(Reader r) {
        this(r, 131072);
    }

    public CharStreamBuffered(Reader r, int buffSize) {
        this.source = new SourceReader(r);
        this.chars = new char[buffSize];
    }

    @Override
    public final int advance() {
        if (this.idx >= this.buffLen) {
            this.fillArray();
        }
        if (this.buffLen >= 0) {
            char ch = this.chars[this.idx];
            ++this.idx;
            return ch;
        }
        return -1;
    }

    private int fillArray() {
        int x = this.source.fill(this.chars);
        if (x >= 0) {
            this.total += (long)x;
        }
        this.idx = 0;
        this.buffLen = x;
        return x;
    }

    @Override
    public void closeStream() {
        this.source.close();
    }

    static final class SourceReader
    implements Source {
        private final Reader reader;
        private boolean isClosed = false;

        SourceReader(Reader r) {
            this.reader = r;
        }

        @Override
        public void close() {
            try {
                this.isClosed = true;
                this.reader.close();
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }

        @Override
        public int fill(char[] array) {
            if (this.isClosed) {
                return -1;
            }
            try {
                return this.reader.read(array);
            }
            catch (EOFException ex) {
                this.close();
                return -1;
            }
            catch (IOException ex) {
                this.close();
                IO.exception(ex);
                return -1;
            }
        }
    }

    private static interface Source {
        public int fill(char[] var1);

        public void close();
    }
}

