/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.objecttools;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.objecttools.AbstractMatcher;
import org.apache.juneau.objecttools.MatcherFactory;
import org.apache.juneau.objecttools.NumberMatcherFactory;
import org.apache.juneau.objecttools.ObjectTool;
import org.apache.juneau.objecttools.SearchArgs;
import org.apache.juneau.objecttools.StringMatcherFactory;
import org.apache.juneau.objecttools.TimeMatcherFactory;

public class ObjectSearcher
implements ObjectTool<SearchArgs> {
    public static final ObjectSearcher DEFAULT = new ObjectSearcher(new MatcherFactory[0]);
    final MatcherFactory[] factories;

    public static ObjectSearcher create(MatcherFactory ... factories) {
        return new ObjectSearcher(factories);
    }

    public ObjectSearcher(MatcherFactory ... factories) {
        this.factories = factories.length == 0 ? (MatcherFactory[])CollectionUtils.a((Object[])new MatcherFactory[]{NumberMatcherFactory.DEFAULT, TimeMatcherFactory.DEFAULT, StringMatcherFactory.DEFAULT}) : factories;
    }

    @Override
    public Object run(BeanSession session, Object input, SearchArgs args) {
        ClassMeta<Object> type = session.getClassMetaForObject(input);
        Map<String, String> search = args.getSearch();
        if (search.isEmpty() || type == null || !type.isCollectionOrArray()) {
            return input;
        }
        List l = null;
        RowMatcher rowMatcher = new RowMatcher(session, search);
        if (type.isCollection()) {
            Collection c = (Collection)input;
            List l2 = l = CollectionUtils.listOfSize((int)c.size());
            c.forEach(x -> {
                if (rowMatcher.matches(x)) {
                    l2.add(x);
                }
            });
        } else {
            int size = Array.getLength(input);
            l = CollectionUtils.listOfSize((int)size);
            for (int i = 0; i < size; ++i) {
                Object o = Array.get(input, i);
                if (!rowMatcher.matches(o)) continue;
                l.add(o);
            }
        }
        return l;
    }

    public <R> List<R> run(Object input, String searchArgs) {
        Object r = this.run(BeanContext.DEFAULT_SESSION, input, SearchArgs.create(searchArgs));
        if (r instanceof List) {
            List r2 = (List)r;
            return r2;
        }
        if (r instanceof Collection) {
            Collection r3 = (Collection)r;
            return CollectionUtils.toList((Collection)r3);
        }
        if (Utils.isArray((Object)r)) {
            return CollectionUtils.l((Object[])((Object[])r));
        }
        return null;
    }

    private class RowMatcher {
        Map<String, ColumnMatcher> entryMatchers = new HashMap<String, ColumnMatcher>();
        BeanSession bs;

        RowMatcher(BeanSession bs, Map query) {
            this.bs = bs;
            query.forEach((k, v) -> this.entryMatchers.put(Utils.s((Object)k), new ColumnMatcher(bs, Utils.s((Object)v))));
        }

        boolean matches(Object o) {
            if (o == null) {
                return false;
            }
            ClassMeta<Object> cm = this.bs.getClassMetaForObject(o);
            if (cm.isMapOrBean()) {
                BeanMap<Object> m = cm.isMap() ? (BeanMap<Object>)o : this.bs.toBeanMap(o);
                for (Map.Entry<String, ColumnMatcher> e : this.entryMatchers.entrySet()) {
                    String key = e.getKey();
                    Object val = null;
                    if (m instanceof BeanMap) {
                        BeanMap<Object> m2 = m;
                        val = m2.getRaw(key);
                    } else {
                        val = m.get(key);
                    }
                    if (e.getValue().matches(val)) continue;
                    return false;
                }
                return true;
            }
            if (cm.isCollection()) {
                for (Object o2 : (Collection)o) {
                    if (this.matches(o2)) continue;
                    return false;
                }
                return true;
            }
            if (cm.isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    if (this.matches(Array.get(o, i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    private class ColumnMatcher {
        String searchPattern;
        AbstractMatcher[] matchers;
        BeanSession bs;

        ColumnMatcher(BeanSession bs, String searchPattern) {
            this.bs = bs;
            this.searchPattern = searchPattern;
            this.matchers = new AbstractMatcher[ObjectSearcher.this.factories.length];
        }

        boolean matches(Object o) {
            ClassMeta<Object> cm = this.bs.getClassMetaForObject(o);
            if (cm == null) {
                return false;
            }
            if (cm.isCollection()) {
                for (Object o2 : (Collection)o) {
                    if (!this.matches(o2)) continue;
                    return true;
                }
                return false;
            }
            if (cm.isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    if (!this.matches(Array.get(o, i))) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < ObjectSearcher.this.factories.length; ++i) {
                if (!ObjectSearcher.this.factories[i].canMatch(cm)) continue;
                if (this.matchers[i] == null) {
                    this.matchers[i] = ObjectSearcher.this.factories[i].create(this.searchPattern);
                }
                return this.matchers[i].matches(cm, o);
            }
            return false;
        }
    }
}

