/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentIntegerAssertion;
import org.apache.juneau.assertions.FluentListAssertion;
import org.apache.juneau.assertions.FluentObjectAssertion;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;

public class FluentStringAssertion<R>
extends FluentObjectAssertion<String, R> {
    private static final Messages MESSAGES = Messages.of(FluentStringAssertion.class, (String)"Messages");
    private static final String MSG_stringDifferedAtPosition = MESSAGES.getString("stringDifferedAtPosition");
    private static final String MSG_expectedStringHadDifferentNumbersOfLines = MESSAGES.getString("expectedStringHadDifferentNumbersOfLines");
    private static final String MSG_expectedStringHadDifferentValuesAtLine = MESSAGES.getString("expectedStringHadDifferentValuesAtLine");
    private static final String MSG_stringEqualedUnexpected = MESSAGES.getString("stringEqualedUnexpected");
    private static final String MSG_stringDidNotContainExpectedSubstring = MESSAGES.getString("stringDidNotContainExpectedSubstring");
    private static final String MSG_stringContainedUnexpectedSubstring = MESSAGES.getString("stringContainedUnexpectedSubstring");
    private static final String MSG_stringWasNotEmpty = MESSAGES.getString("stringWasNotEmpty");
    private static final String MSG_stringWasNull = MESSAGES.getString("stringWasNull");
    private static final String MSG_stringWasEmpty = MESSAGES.getString("stringWasEmpty");
    private static final String MSG_stringDidNotMatchExpectedPattern = MESSAGES.getString("stringDidNotMatchExpectedPattern");
    private static final String MSG_stringDidNotStartWithExpected = MESSAGES.getString("stringDidNotStartWithExpected");
    private static final String MSG_stringDidNotEndWithExpected = MESSAGES.getString("stringDidNotEndWithExpected");
    private boolean javaStrings;

    public FluentStringAssertion(Assertion creator, String value, R returns) {
        super(creator, value, returns);
    }

    public FluentStringAssertion(String value, R returns) {
        this((Assertion)null, value, returns);
    }

    public FluentStringAssertion<R> asJavaStrings() {
        this.javaStrings = true;
        return this;
    }

    public FluentStringAssertion<R> asLc() {
        return this.asTransformed(x -> x == null ? null : x.toLowerCase());
    }

    public FluentIntegerAssertion<R> asLength() {
        return new FluentIntegerAssertion((Assertion)this, this.valueIsNull() ? null : Integer.valueOf(((String)this.value()).length()), this.returns());
    }

    public FluentListAssertion<String, R> asLines() {
        return this.asSplit("[\r\n]+");
    }

    public FluentStringAssertion<R> asOneLine() {
        return this.asTransformed(x -> x == null ? null : x.replaceAll("\\s*[\r\n]+\\s*", "  "));
    }

    public FluentStringAssertion<R> asReplace(String target, String replacement) {
        AssertionUtils.assertArgNotNull((String)"target", (Object)target);
        AssertionUtils.assertArgNotNull((String)"replacement", (Object)replacement);
        return this.asTransformed(x -> x == null ? null : x.replace(target, replacement));
    }

    public FluentStringAssertion<R> asReplaceAll(String regex, String replacement) {
        AssertionUtils.assertArgNotNull((String)"regex", (Object)regex);
        AssertionUtils.assertArgNotNull((String)"replacement", (Object)replacement);
        return this.asTransformed(x -> x == null ? null : x.replaceAll(regex, replacement));
    }

    public FluentListAssertion<String, R> asSplit(String regex) {
        AssertionUtils.assertArgNotNull((String)"regex", (Object)regex);
        return new FluentListAssertion((Assertion)this, this.valueIsNull() ? null : CollectionUtils.l((Object[])((String)this.value()).trim().split(regex)), this.returns());
    }

    public FluentStringAssertion<R> asTransformed(Function<String, String> function) {
        return new FluentStringAssertion((Assertion)this, function.apply(this.orElse(null)), this.returns());
    }

    public FluentStringAssertion<R> asTrimmed() {
        return new FluentStringAssertion((Assertion)this, this.valueIsNull() ? null : ((String)this.value()).trim(), this.returns());
    }

    public FluentStringAssertion<R> asUc() {
        return this.asTransformed(x -> x == null ? null : x.toUpperCase());
    }

    public FluentStringAssertion<R> asUrlDecode() {
        return this.asTransformed(StringUtils::urlDecode);
    }

    @Override
    public R is(String value) throws AssertionError {
        String s = this.orElse(null);
        if (Utils.neq((Object)value, (Object)s)) {
            throw this.error(MSG_stringDifferedAtPosition, StringUtils.diffPosition((String)value, (String)s), this.fix(value), this.fix(s));
        }
        return this.returns();
    }

    public R isContains(String ... values) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"values", (Object)values);
        String s = this.orElse(null);
        for (String substring : values) {
            if (!Utils.nn((Object)substring) || StringUtils.contains((String)s, (String)substring)) continue;
            throw this.error(MSG_stringDidNotContainExpectedSubstring, this.fix(substring), this.fix(s));
        }
        return this.returns();
    }

    public R isEmpty() throws AssertionError {
        String s = this.orElse(null);
        if (Utils.nn((Object)s) && !s.isEmpty()) {
            throw this.error(MSG_stringWasNotEmpty, this.fix(s));
        }
        return this.returns();
    }

    public R isEndsWith(String string) {
        AssertionUtils.assertArgNotNull((String)"string", (Object)string);
        String s = (String)this.value();
        if (!s.endsWith(string)) {
            throw this.error(MSG_stringDidNotEndWithExpected, this.fix(string), this.fix(s));
        }
        return this.returns();
    }

    public R isIc(String value) throws AssertionError {
        String s = this.orElse(null);
        if (Utils.neqic((String)value, (String)s)) {
            throw this.error(MSG_stringDifferedAtPosition, StringUtils.diffPositionIc((String)value, (String)s), this.fix(value), this.fix(s));
        }
        return this.returns();
    }

    public R isLines(String ... lines) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"lines", (Object)lines);
        String v = StringUtils.join((Object[])lines, (char)'\n');
        String s = (String)this.value();
        if (Utils.neq((Object)v, (Object)s)) {
            throw this.error(MSG_stringDifferedAtPosition, StringUtils.diffPosition((String)v, (String)s), this.fix(v), this.fix(s));
        }
        return this.returns();
    }

    public R isMatches(String searchPattern) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"searchPattern", (Object)searchPattern);
        return this.isPattern(StringUtils.getMatchPattern((String)searchPattern));
    }

    @Override
    public R isNot(String value) throws AssertionError {
        String s = this.orElse(null);
        if (Utils.eq((Object)value, (Object)s)) {
            throw this.error(MSG_stringEqualedUnexpected, this.fix(s));
        }
        return this.returns();
    }

    public R isNotContains(String ... values) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"values", (Object)values);
        String s = this.orElse(null);
        for (String substring : values) {
            if (!Utils.nn((Object)substring) || !StringUtils.contains((String)s, (String)substring)) continue;
            throw this.error(MSG_stringContainedUnexpectedSubstring, this.fix(substring), this.fix(s));
        }
        return this.returns();
    }

    public R isNotEmpty() throws AssertionError {
        String s = this.orElse(null);
        if (s == null) {
            throw this.error(MSG_stringWasNull, new Object[0]);
        }
        if (s.isEmpty()) {
            throw this.error(MSG_stringWasEmpty, new Object[0]);
        }
        return this.returns();
    }

    public R isNotIc(String value) throws AssertionError {
        String s = this.orElse(null);
        if (Utils.eqic((String)value, (String)s)) {
            throw this.error(MSG_stringEqualedUnexpected, this.fix(s));
        }
        return this.returns();
    }

    public R isPattern(Pattern pattern) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"pattern", (Object)pattern);
        String s = (String)this.value();
        if (!pattern.matcher(s).matches()) {
            throw this.error(MSG_stringDidNotMatchExpectedPattern, this.fix(pattern.pattern()), this.fix(s));
        }
        return this.returns();
    }

    public R isPattern(String regex) throws AssertionError {
        return this.isPattern(regex, 0);
    }

    public R isPattern(String regex, int flags) throws AssertionError {
        AssertionUtils.assertArgNotNull((String)"regex", (Object)regex);
        Pattern p = Pattern.compile(regex, flags);
        String s = (String)this.value();
        if (!p.matcher(s).matches()) {
            throw this.error(MSG_stringDidNotMatchExpectedPattern, this.fix(regex), this.fix(s));
        }
        return this.returns();
    }

    public R isSortedLines(String ... lines) {
        AssertionUtils.assertArgNotNull((String)"lines", (Object)lines);
        Object[] e = StringUtils.join((Object[])lines, (char)'\n').trim().split("[\r\n]+");
        Object[] a = ((String)this.value()).trim().split("[\r\n]+");
        if (e.length != a.length) {
            throw this.error(MSG_expectedStringHadDifferentNumbersOfLines, e.length, a.length);
        }
        Arrays.sort(e);
        Arrays.sort(a);
        for (int i = 0; i < e.length; ++i) {
            if (((String)e[i]).equals(a[i])) continue;
            throw this.error(MSG_expectedStringHadDifferentValuesAtLine, i + 1, e[i], a[i]);
        }
        return this.returns();
    }

    public R isStartsWith(String string) {
        AssertionUtils.assertArgNotNull((String)"string", (Object)string);
        String s = (String)this.value();
        if (!s.startsWith(string)) {
            throw this.error(MSG_stringDidNotStartWithExpected, this.fix(string), this.fix(s));
        }
        return this.returns();
    }

    public R isString(Object value) {
        return this.is(value == null ? null : this.toString());
    }

    @Override
    public FluentStringAssertion<R> setMsg(String msg, Object ... args) {
        super.setMsg(msg, args);
        return this;
    }

    @Override
    public FluentStringAssertion<R> setOut(PrintStream value) {
        super.setOut(value);
        return this;
    }

    @Override
    public FluentStringAssertion<R> setSilent() {
        super.setSilent();
        return this;
    }

    @Override
    public FluentStringAssertion<R> setStdOut() {
        super.setStdOut();
        return this;
    }

    @Override
    public FluentStringAssertion<R> setThrowable(Class<? extends RuntimeException> value) {
        super.setThrowable((Class)value);
        return this;
    }

    private String fix(String text) {
        if (this.javaStrings) {
            text = text.replace("\\", "\\\\").replace("\n", "\\n").replace("\t", "\\t");
        }
        return text;
    }
}

