/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.security;

import org.apache.kafka.common.config.ConfigDef;

public class PasswordEncoderConfigs {
    public static final String PASSWORD_ENCODER_SECRET_CONFIG = "password.encoder.secret";
    public static final String PASSWORD_ENCODER_SECRET_DOC = "The secret used for encoding dynamically configured passwords for this broker.";
    public static final String PASSWORD_ENCODER_OLD_SECRET_CONFIG = "password.encoder.old.secret";
    public static final String PASSWORD_ENCODER_OLD_SECRET_DOC = "The old secret that was used for encoding dynamically configured passwords. This is required only when the secret is updated. If specified, all dynamically encoded passwords are decoded using this old secret and re-encoded using password.encoder.secret when broker starts up.";
    public static final String PASSWORD_ENCODER_KEYFACTORY_ALGORITHM_CONFIG = "password.encoder.keyfactory.algorithm";
    public static final String PASSWORD_ENCODER_KEYFACTORY_ALGORITHM_DOC = "The SecretKeyFactory algorithm used for encoding dynamically configured passwords. Default is PBKDF2WithHmacSHA512 if available and PBKDF2WithHmacSHA1 otherwise.";
    public static final String PASSWORD_ENCODER_CIPHER_ALGORITHM_CONFIG = "password.encoder.cipher.algorithm";
    public static final String PASSWORD_ENCODER_CIPHER_ALGORITHM_DOC = "The Cipher algorithm used for encoding dynamically configured passwords.";
    public static final String PASSWORD_ENCODER_CIPHER_ALGORITHM_DEFAULT = "AES/CBC/PKCS5Padding";
    public static final String PASSWORD_ENCODER_KEY_LENGTH_CONFIG = "password.encoder.key.length";
    public static final String PASSWORD_ENCODER_KEY_LENGTH_DOC = "The key length used for encoding dynamically configured passwords.";
    public static final int PASSWORD_ENCODER_KEY_LENGTH_DEFAULT = 128;
    public static final String PASSWORD_ENCODER_ITERATIONS_CONFIG = "password.encoder.iterations";
    public static final String PASSWORD_ENCODER_ITERATIONS_DOC = "The iteration count used for encoding dynamically configured passwords.";
    public static final int PASSWORD_ENCODER_ITERATIONS_DEFAULT = 4096;
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("password.encoder.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "The secret used for encoding dynamically configured passwords for this broker.").define("password.encoder.old.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.MEDIUM, "The old secret that was used for encoding dynamically configured passwords. This is required only when the secret is updated. If specified, all dynamically encoded passwords are decoded using this old secret and re-encoded using password.encoder.secret when broker starts up.").define("password.encoder.keyfactory.algorithm", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The SecretKeyFactory algorithm used for encoding dynamically configured passwords. Default is PBKDF2WithHmacSHA512 if available and PBKDF2WithHmacSHA1 otherwise.").define("password.encoder.cipher.algorithm", ConfigDef.Type.STRING, (Object)"AES/CBC/PKCS5Padding", ConfigDef.Importance.LOW, "The Cipher algorithm used for encoding dynamically configured passwords.").define("password.encoder.key.length", ConfigDef.Type.INT, (Object)128, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)8), ConfigDef.Importance.LOW, "The key length used for encoding dynamically configured passwords.").define("password.encoder.iterations", ConfigDef.Type.INT, (Object)4096, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1024), ConfigDef.Importance.LOW, "The iteration count used for encoding dynamically configured passwords.");
}

