/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.UnifiedLog;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorLoader;
import org.apache.kafka.coordinator.common.runtime.CoordinatorPlayback;
import org.apache.kafka.coordinator.common.runtime.Deserializer;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005]c\u0001B\u0007\u000f\u0001UA\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001dy\u0006A1A\u0005\n\u0001Daa\u001b\u0001!\u0002\u0013\t\u0007b\u00027\u0001\u0005\u0004%I!\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00028\t\u000bU\u0004A\u0011\t<\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u00111\u000b\u0001\u0005B\u0005U#!F\"p_J$\u0017N\\1u_Jdu.\u00193fe&k\u0007\u000f\u001c\u0006\u0003\u001fA\tQa\u001a:pkBT!!\u0005\n\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002'\u0005)1.\u00194lC\u000e\u0001QC\u0001\f0'\u0011\u0001qcH\u001e\u0011\u0005aiR\"A\r\u000b\u0005iY\u0012\u0001\u00027b]\u001eT\u0011\u0001H\u0001\u0005U\u00064\u0018-\u0003\u0002\u001f3\t1qJ\u00196fGR\u00042\u0001I\u0016.\u001b\u0005\t#B\u0001\u0012$\u0003\u001d\u0011XO\u001c;j[\u0016T!\u0001J\u0013\u0002\r\r|W.\\8o\u0015\t\tbE\u0003\u0002\u0014O)\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0013\ta\u0013EA\tD_>\u0014H-\u001b8bi>\u0014Hj\\1eKJ\u0004\"AL\u0018\r\u0001\u0011)\u0001\u0007\u0001b\u0001c\t\tA+\u0005\u00023qA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t9aj\u001c;iS:<\u0007CA\u001a:\u0013\tQDGA\u0002B]f\u0004\"\u0001P \u000e\u0003uR!A\u0010\n\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001k$a\u0002'pO\u001eLgnZ\u0001\u0005i&lW\r\u0005\u0002D\r6\tAI\u0003\u0002?\u000b*\u0011AEJ\u0005\u0003\u000f\u0012\u0013A\u0001V5nK\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001&N\u001b\u0005Y%B\u0001'\u0013\u0003\u0019\u0019XM\u001d<fe&\u0011aj\u0013\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u00031!Wm]3sS\u0006d\u0017N_3s!\r\u0001\u0013+L\u0005\u0003%\u0006\u0012A\u0002R3tKJL\u0017\r\\5{KJ\fa\u0002\\8bI\n+hMZ3s'&TX\r\u0005\u00024+&\u0011a\u000b\u000e\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0003Z7rkf\fE\u0002[\u00015j\u0011A\u0004\u0005\u0006\u0003\u0016\u0001\rA\u0011\u0005\u0006\u0011\u0016\u0001\r!\u0013\u0005\u0006\u001f\u0016\u0001\r\u0001\u0015\u0005\u0006'\u0016\u0001\r\u0001V\u0001\nSN\u0014VO\u001c8j]\u001e,\u0012!\u0019\t\u0003E&l\u0011a\u0019\u0006\u0003I\u0016\fa!\u0019;p[&\u001c'B\u00014h\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003Qn\tA!\u001e;jY&\u0011!n\u0019\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0015%\u001c(+\u001e8oS:<\u0007%A\u0005tG\",G-\u001e7feV\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002ic*\u0011AJJ\u0005\u0003gB\u0014abS1gW\u0006\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\nA\u0001\\8bIR)q/a\t\u00020A\u0019\u00010_>\u000e\u0003\u0015L!A_3\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\rE\u0002}\u0003;q1!`A\r\u001d\rq\u0018q\u0003\b\u0004\u007f\u0006Ua\u0002BA\u0001\u0003'qA!a\u0001\u0002\u00129!\u0011QAA\b\u001d\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006)\u00051AH]8pizJ\u0011AK\u0005\u0003Q%J!aE\u0014\n\u0005E1\u0013B\u0001\u0013&\u0013\t\u00113%C\u0002\u0002\u001c\u0005\n\u0011cQ8pe\u0012Lg.\u0019;pe2{\u0017\rZ3s\u0013\u0011\ty\"!\t\u0003\u00171{\u0017\rZ*v[6\f'/\u001f\u0006\u0004\u00037\t\u0003bBA\u0013\u0015\u0001\u0007\u0011qE\u0001\u0003iB\u0004B!!\u000b\u0002,5\tQ)C\u0002\u0002.\u0015\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0012\u0015\u0001\u0007\u0011\u0011\u0007\t\u0005A\u0005MR&C\u0002\u00026\u0005\u00121cQ8pe\u0012Lg.\u0019;peBc\u0017-\u001f2bG.\fa\u0001Z8M_\u0006$GCCA\u001e\u0003\u0003\n\u0019%!\u0012\u0002JA\u00191'!\u0010\n\u0007\u0005}BG\u0001\u0003V]&$\bbBA\u0013\u0017\u0001\u0007\u0011q\u0005\u0005\u0007#-\u0001\r!!\r\t\r\u0005\u001d3\u00021\u0001x\u0003\u00191W\u000f^;sK\"9\u00111J\u0006A\u0002\u00055\u0013aC:uCJ$H+[7f\u001bN\u00042aMA(\u0013\r\t\t\u0006\u000e\u0002\u0005\u0019>tw-A\u0003dY>\u001cX\r\u0006\u0002\u0002<\u0001")
public class CoordinatorLoaderImpl<T>
implements CoordinatorLoader<T>,
Logging {
    private final Time time;
    private final ReplicaManager replicaManager;
    private final Deserializer<T> deserializer;
    private final int loadBufferSize;
    private final AtomicBoolean isRunning;
    private final KafkaScheduler scheduler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isRunning() {
        return this.isRunning;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public CompletableFuture<CoordinatorLoader.LoadSummary> load(TopicPartition tp, CoordinatorPlayback<T> coordinator) {
        CompletableFuture<CoordinatorLoader.LoadSummary> future = new CompletableFuture<CoordinatorLoader.LoadSummary>();
        long startTimeMs = this.time.milliseconds();
        if (this.scheduler().scheduleOnce("Load coordinator from " + tp, () -> this.doLoad(tp, coordinator, future, startTimeMs)).isCancelled()) {
            future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
        }
        return future;
    }

    private void doLoad(TopicPartition tp, CoordinatorPlayback<T> coordinator, CompletableFuture<CoordinatorLoader.LoadSummary> future, long startTimeMs) {
        block16: {
            long schedulerQueueTimeMs = this.time.milliseconds() - startTimeMs;
            try {
                Option<UnifiedLog> option = this.replicaManager.getLog(tp);
                if (None$.MODULE$.equals(option)) {
                    future.completeExceptionally((Throwable)new NotLeaderOrFollowerException("Could not load records from " + tp + " because the log does not exist."));
                    break block16;
                }
                if (option instanceof Some) {
                    UnifiedLog log = (UnifiedLog)((Some)option).value();
                    ByteBuffer buffer = ByteBuffer.allocate(0);
                    LongRef currentOffset = LongRef.create((long)log.logStartOffset());
                    boolean readAtLeastOneRecord = true;
                    LongRef previousHighWatermark = LongRef.create((long)-1L);
                    LongRef numRecords = LongRef.create((long)0L);
                    long numBytes = 0L;
                    while (currentOffset.elem < this.logEndOffset$1(tp) && readAtLeastOneRecord && this.isRunning().get()) {
                        MemoryRecords memoryRecords;
                        FetchDataInfo fetchDataInfo = log.read(currentOffset.elem, this.loadBufferSize, FetchIsolation.LOG_END, true);
                        readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                        Records records = fetchDataInfo.records;
                        if (records instanceof MemoryRecords) {
                            memoryRecords = (MemoryRecords)records;
                        } else if (records instanceof FileRecords) {
                            FileRecords fileRecords = (FileRecords)records;
                            int sizeInBytes = fileRecords.sizeInBytes();
                            int bytesNeeded = Math.max(this.loadBufferSize, sizeInBytes);
                            if (buffer.capacity() < bytesNeeded) {
                                if (this.loadBufferSize < bytesNeeded) {
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Loaded metadata from " + tp + " with buffer larger (" + bytesNeeded + " bytes) than configured buffer size (" + $this.loadBufferSize + " bytes).");
                                }
                                buffer = ByteBuffer.allocate(bytesNeeded);
                            } else {
                                buffer.clear();
                            }
                            fileRecords.readInto(buffer, 0);
                            memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                        } else {
                            throw new MatchError((Object)records);
                        }
                        MemoryRecords memoryRecords2 = memoryRecords;
                        memoryRecords2.batches().forEach(batch -> {
                            if (batch.isControlBatch()) {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$4(this, tp, batch, coordinator, record);
                                    return BoxedUnit.UNIT;
                                });
                            } else {
                                CollectionConverters$.MODULE$.IterableHasAsScala((Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                                    CoordinatorLoaderImpl.$anonfun$doLoad$7(this, numRecords, tp, batch, coordinator, record);
                                    return BoxedUnit.UNIT;
                                });
                            }
                            currentOffset$1.elem = batch.nextOffset();
                            long currentHighWatermark = log.highWatermark();
                            if (currentOffset$1.elem >= currentHighWatermark) {
                                coordinator.updateLastWrittenOffset(Predef$.MODULE$.long2Long(currentOffset$1.elem));
                                if (currentHighWatermark > previousHighWatermark$1.elem) {
                                    coordinator.updateLastCommittedOffset(Predef$.MODULE$.long2Long(currentHighWatermark));
                                    previousHighWatermark$1.elem = currentHighWatermark;
                                    return;
                                }
                                return;
                            }
                        });
                        numBytes += (long)memoryRecords2.sizeInBytes();
                    }
                    long endTimeMs = this.time.milliseconds();
                    if (this.logEndOffset$1(tp) == -1L) {
                        future.completeExceptionally((Throwable)new NotLeaderOrFollowerException("Stopped loading records from " + tp + " because the partition is not online or is no longer the leader."));
                    } else if (this.isRunning().get()) {
                        future.complete(new CoordinatorLoader.LoadSummary(startTimeMs, endTimeMs, schedulerQueueTimeMs, numRecords.elem, numBytes));
                    } else {
                        future.completeExceptionally(new RuntimeException("Coordinator loader is closed."));
                    }
                    break block16;
                }
                throw new MatchError(option);
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
        }
    }

    public void close() {
        if (!this.isRunning().compareAndSet(true, false)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Coordinator loader is already shutting down.");
            return;
        }
        this.scheduler().shutdown();
    }

    private final long logEndOffset$1(TopicPartition tp$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(tp$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ void $anonfun$doLoad$4(CoordinatorLoaderImpl $this, TopicPartition tp$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Record record) {
        block10: {
            block9: {
                ControlRecordType controlRecordType;
                ControlRecordType controlRecordType2;
                block8: {
                    ControlRecordType controlRecord;
                    ControlRecordType controlRecordType3 = controlRecord = ControlRecordType.parse((ByteBuffer)record.key());
                    ControlRecordType controlRecordType4 = ControlRecordType.COMMIT;
                    if (!(controlRecordType3 != null ? !controlRecordType3.equals(controlRecordType4) : controlRecordType4 != null)) {
                        if ($this.isTraceEnabled()) {
                            $this.trace((Function0<String>)(Function0 & Serializable)() -> "Replaying end transaction marker from " + tp$2 + " at offset " + record.offset() + " to commit transaction with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + ".");
                        }
                        coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.COMMIT);
                        return;
                    }
                    controlRecordType2 = controlRecord;
                    controlRecordType = ControlRecordType.ABORT;
                    if (controlRecordType2 != null) break block8;
                    if (controlRecordType != null) {
                        return;
                    }
                    break block9;
                }
                if (!controlRecordType2.equals(controlRecordType)) break block10;
            }
            if ($this.isTraceEnabled()) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Replaying end transaction marker from " + tp$2 + " at offset " + record.offset() + " to abort transaction with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + ".");
            }
            coordinator$2.replayEndTransactionMarker(batch$1.producerId(), batch$1.producerEpoch(), TransactionResult.ABORT);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$10(CoordinatorLoaderImpl $this, TopicPartition tp$2, Record record$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Object coordinatorRecord) {
        try {
            if ($this.isTraceEnabled()) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> "Replaying record " + coordinatorRecord + " from " + tp$2 + " at offset " + record$2.offset() + " with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + ".");
            }
            coordinator$2.replay(record$2.offset(), batch$1.producerId(), batch$1.producerEpoch(), coordinatorRecord);
            return;
        }
        catch (RuntimeException ex) {
            String msg = "Replaying record " + coordinatorRecord + " from " + tp$2 + " at offset " + record$2.offset() + " with producer id " + batch$1.producerId() + " and producer epoch " + batch$1.producerEpoch() + " failed due to: " + ex.getMessage();
            $this.error((Function0<String>)(Function0 & Serializable)() -> msg + ".");
            throw new RuntimeException(msg, ex);
        }
    }

    public static final /* synthetic */ void $anonfun$doLoad$7(CoordinatorLoaderImpl $this, LongRef numRecords$1, TopicPartition tp$2, MutableRecordBatch batch$1, CoordinatorPlayback coordinator$2, Record record) {
        Some some;
        ++numRecords$1.elem;
        try {
            some = new Some($this.deserializer.deserialize(record.key(), record.value()));
        }
        catch (Deserializer.UnknownRecordTypeException ex) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> "Unknown record type " + ex.unknownType() + " while loading offsets and group metadata from " + tp$2 + ". Ignoring it. It could be a left over from an aborted upgrade.");
            some = None$.MODULE$;
        }
        catch (RuntimeException ex) {
            String msg = "Deserializing record " + record + " from " + tp$2 + " failed due to: " + ex.getMessage();
            $this.error((Function0<String>)(Function0 & Serializable)() -> msg + ".");
            throw new RuntimeException(msg, ex);
        }
        some.foreach((Function1 & Serializable)coordinatorRecord -> {
            CoordinatorLoaderImpl.$anonfun$doLoad$10($this, tp$2, record, batch$1, coordinator$2, coordinatorRecord);
            return BoxedUnit.UNIT;
        });
    }

    public CoordinatorLoaderImpl(Time time, ReplicaManager replicaManager, Deserializer<T> deserializer, int loadBufferSize) {
        this.time = time;
        this.replicaManager = replicaManager;
        this.deserializer = deserializer;
        this.loadBufferSize = loadBufferSize;
        this.isRunning = new AtomicBoolean(true);
        this.scheduler = new KafkaScheduler(1);
        this.scheduler().startup();
    }
}

