/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.LoggerFactory;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String LOGGER = "logger";
    static final String LOGGER_REF = "logger-ref";
    static final String CATEGORY_FACTORY_TAG = "categoryFactory";
    static final String LOGGER_FACTORY_TAG = "loggerFactory";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String ROOT_REF = "root-ref";
    static final String LEVEL_TAG = "level";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String THRESHOLD_ATTR = "threshold";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{String.class};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    protected LoggerFactory catFactory = null;

    protected Appender findAppenderByName(Document doc, String appenderName) {
        Appender appender = (Appender)this.appenderBag.get(appenderName);
        if (appender != null) {
            return appender;
        }
        Element element = null;
        NodeList list = doc.getElementsByTagName(APPENDER_TAG);
        for (int t = 0; t < list.getLength(); ++t) {
            Node node = list.item(t);
            NamedNodeMap map = node.getAttributes();
            Node attrNode = map.getNamedItem(NAME_ATTR);
            if (!appenderName.equals(attrNode.getNodeValue())) continue;
            element = (Element)node;
            break;
        }
        if (element == null) {
            LogLog.error("No appender named [" + appenderName + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element);
        if (appender != null) {
            this.appenderBag.put(appenderName, appender);
        }
        return appender;
    }

    protected Appender findAppenderByReference(Element appenderRef) {
        String appenderName = this.subst(appenderRef.getAttribute(REF_ATTR));
        Document doc = appenderRef.getOwnerDocument();
        return this.findAppenderByName(doc, appenderName);
    }

    protected Appender parseAppender(Element appenderElement) {
        return null;
    }

    protected void parseErrorHandler(Element element, Appender appender) {
    }

    protected void parseFilters(Element element, Appender appender) {
    }

    protected void parseCategory(Element loggerElement) {
    }

    protected void parseCategoryFactory(Element factoryElement) {
    }

    protected void parseRoot(Element rootElement) {
    }

    protected void parseChildrenOfLoggerElement(Element catElement, Logger cat, boolean isRoot) {
    }

    protected Layout parseLayout(Element layout_element) {
        return null;
    }

    protected void parseRenderer(Element element) {
    }

    protected ThrowableRenderer parseThrowableRenderer(Element element) {
        return null;
    }

    protected void parseLevel(Element element, Logger logger, boolean isRoot) {
    }

    protected void setParameter(Element elem, PropertySetter propSetter) {
    }

    public static void configure(Element element) {
    }

    public static void configureAndWatch(String configFilename) {
    }

    public static void configureAndWatch(String configFilename, long delay) {
    }

    public void doConfigure(String filename, LoggerRepository repository) {
    }

    @Override
    public void doConfigure(URL url, LoggerRepository repository) {
    }

    @Override
    public void doConfigure(InputStream inputStream, LoggerRepository repository) throws FactoryConfigurationError {
    }

    public void doConfigure(Reader reader, LoggerRepository repository) throws FactoryConfigurationError {
    }

    protected void doConfigure(InputSource inputSource, LoggerRepository repository) throws FactoryConfigurationError {
    }

    public void doConfigure(Element element, LoggerRepository repository) {
    }

    public static void configure(String filename) throws FactoryConfigurationError {
    }

    public static void configure(URL url) throws FactoryConfigurationError {
    }

    protected void parse(Element element) {
    }

    protected String subst(String value) {
        return value;
    }

    public static String subst(String value, Properties props) {
        try {
            return OptionConverter.substVars(value, props);
        }
        catch (IllegalArgumentException e) {
            LogLog.warn("Could not perform variable substitution.", e);
            return value;
        }
    }

    public static void setParameter(Element elem, PropertySetter propSetter, Properties props) {
        String name = DOMConfigurator.subst(elem.getAttribute(NAME_ATTR), props);
        String value = elem.getAttribute(VALUE_ATTR);
        value = DOMConfigurator.subst(OptionConverter.convertSpecialChars(value), props);
        propSetter.setProperty(name, value);
    }

    public static Object parseElement(Element element, Properties props, Class expectedClass) throws Exception {
        return null;
    }
}

