/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Map;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.NumberUtils;

public interface PublicKeyRawDataDecoder<PUB extends PublicKey> {
    default public PUB decodePublicKey(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        return this.decodePublicKey(session, keyType, keyData, 0, NumberUtils.length(keyData), headers);
    }

    default public PUB decodePublicKey(SessionContext session, String keyType, byte[] keyData, int offset, int length, Map<String, String> headers) throws IOException, GeneralSecurityException {
        if (length <= 0) {
            return null;
        }
        try (ByteArrayInputStream stream = new ByteArrayInputStream(keyData, offset, length);){
            PUB PUB = this.decodePublicKeyByType(session, keyType, stream, headers);
            return PUB;
        }
    }

    public PUB decodePublicKeyByType(SessionContext var1, String var2, InputStream var3, Map<String, String> var4) throws IOException, GeneralSecurityException;

    public PUB decodePublicKey(SessionContext var1, String var2, InputStream var3, Map<String, String> var4) throws IOException, GeneralSecurityException;
}

