/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.metrics.impl.reporters;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.metrics.MetricsContext;
import org.apache.knox.gateway.services.metrics.MetricsReporterException;
import org.apache.knox.gateway.services.metrics.impl.reporters.AbstractMetricsReporter;

public class GraphiteMetricsReporter
extends AbstractMetricsReporter {
    public static final String NAME = "graphite-reporter";
    private Graphite graphite;
    private GraphiteReporter reporter;
    private int reportingFrequency = 1;

    public void init(GatewayConfig config) throws MetricsReporterException {
        if (config.isMetricsEnabled() && config.isGraphiteMetricsReportingEnabled()) {
            this.graphite = new Graphite(new InetSocketAddress(config.getGraphiteHost(), config.getGraphitePort()));
            this.reportingFrequency = config.getGraphiteReportingFrequency();
            this.setEnabled(true);
        }
    }

    public void start(MetricsContext metricsContext) throws MetricsReporterException {
        MetricRegistry registry = (MetricRegistry)metricsContext.getProperty("metrics-registry");
        this.reporter = GraphiteReporter.forRegistry((MetricRegistry)registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(this.graphite);
        this.reporter.start((long)this.reportingFrequency, TimeUnit.MINUTES);
    }

    public void stop() throws MetricsReporterException {
        this.reporter.stop();
    }

    public String getName() {
        return NAME;
    }
}

