/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineResultSet;
import org.apache.derby.impl.drda.ReEncodedInputStream;
import org.apache.derby.impl.jdbc.Util;

class EXTDTAInputStream
extends InputStream {
    private InputStream binaryInputStream = null;
    int ndrdaType;
    EngineResultSet rs;
    int columnNumber;
    private Clob _clob;
    private Blob _blob;

    private EXTDTAInputStream(ResultSet resultSet, int n, int n2) {
        this.rs = (EngineResultSet)resultSet;
        this.columnNumber = n;
        this.ndrdaType = n2;
    }

    private EXTDTAInputStream(Clob clob, int n) {
        this._clob = clob;
        this.ndrdaType = n;
    }

    private EXTDTAInputStream(Blob blob, int n) {
        this._blob = blob;
        this.ndrdaType = n;
    }

    public static EXTDTAInputStream getEXTDTAStream(ResultSet resultSet, int n, int n2) {
        int n3 = n2 | 1;
        return new EXTDTAInputStream(resultSet, n, n3);
    }

    public static EXTDTAInputStream getEXTDTAStream(CallableStatement callableStatement, int n, int n2) throws SQLException {
        int n3 = n2 | 1;
        switch (n3) {
            case 201: {
                Blob blob = callableStatement.getBlob(n);
                if (blob == null) {
                    return null;
                }
                return new EXTDTAInputStream(blob, n3);
            }
            case 207: {
                Clob clob = callableStatement.getClob(n);
                if (clob == null) {
                    return null;
                }
                return new EXTDTAInputStream(clob, n3);
            }
        }
        EXTDTAInputStream.badDRDAType(n3);
        return null;
    }

    @Override
    public int read() throws IOException {
        return this.binaryInputStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.binaryInputStream.available();
    }

    @Override
    public void close() throws IOException {
        if (this.binaryInputStream != null) {
            this.binaryInputStream.close();
        }
        this.binaryInputStream = null;
    }

    public boolean equals(Object object) {
        return this.binaryInputStream.equals(object);
    }

    public int hashCode() {
        return this.binaryInputStream.hashCode();
    }

    @Override
    public void mark(int n) {
        this.binaryInputStream.mark(n);
    }

    @Override
    public boolean markSupported() {
        return this.binaryInputStream.markSupported();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.binaryInputStream.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.binaryInputStream.read(byArray, n, n2);
    }

    @Override
    public void reset() throws IOException {
        this.binaryInputStream.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        if (l < 0L) {
            return 0L;
        }
        return this.binaryInputStream.skip(l);
    }

    protected boolean isEmptyStream() throws SQLException {
        return this.length() == 0L;
    }

    private long length() throws SQLException {
        if (this.rs != null) {
            return this.rs.getLength(this.columnNumber);
        }
        if (this._clob != null) {
            return this._clob.length();
        }
        return this._blob.length();
    }

    public void initInputStream() throws SQLException {
        InputStream inputStream = null;
        Reader reader = null;
        if (this.ndrdaType == 201) {
            inputStream = this.getBinaryStream();
            if (inputStream == null) {
                return;
            }
        } else if (this.ndrdaType == 207) {
            try {
                reader = this.getCharacterStream();
                if (reader == null) {
                    return;
                }
                inputStream = new ReEncodedInputStream(reader);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw Util.javaException((Throwable)unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw Util.javaException((Throwable)iOException);
            }
        } else {
            EXTDTAInputStream.badDRDAType(this.ndrdaType);
        }
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.binaryInputStream = inputStream;
    }

    private InputStream getBinaryStream() throws SQLException {
        if (this.rs != null) {
            return this.rs.getBinaryStream(this.columnNumber);
        }
        return this._blob.getBinaryStream();
    }

    private Reader getCharacterStream() throws SQLException {
        if (this.rs != null) {
            return this.rs.getCharacterStream(this.columnNumber);
        }
        return this._clob.getCharacterStream();
    }

    private static void badDRDAType(int n) {
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isNull() throws SQLException {
        if (this.rs != null) {
            return this.rs.isNull(this.columnNumber);
        }
        return this._clob == null && this._blob == null;
    }
}

