/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.service.TempFileService$;
import org.apache.kyuubi.util.TempFileCleanupUtils$;
import org.apache.kyuubi.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\t\u0013\u0001mA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006]\u0001!\ta\f\u0005\u0006]\u0001!\tA\r\u0005\ng\u0001\u0001\r\u00111A\u0005\u000eQB\u0011\"\u0011\u0001A\u0002\u0003\u0007IQ\u0002\"\t\u0013%\u0003\u0001\u0019!A!B\u001b)\u0004\u0002\u0003&\u0001\u0011\u000b\u0007I\u0011B&\t\u000bY\u0003A\u0011A,\t\u000bm\u0003A\u0011\t/\t\u000b\u0015\u0004A\u0011\t4\t\u000b\u001d\u0004A\u0011\u00025\t\u000b-\u0004A\u0011\u00017\b\u000b]\u0014\u0002\u0012\u0001=\u0007\u000bE\u0011\u0002\u0012A=\t\u000b9rA\u0011A?\t\u0011yt\u0001R1A\u0005\n}\u0014q\u0002V3na\u001aKG.Z*feZL7-\u001a\u0006\u0003'Q\tqa]3sm&\u001cWM\u0003\u0002\u0016-\u000511._;vE&T!a\u0006\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0012aA8sO\u000e\u00011C\u0001\u0001\u001d!\tib$D\u0001\u0013\u0013\ty\"CA\bBEN$(/Y2u'\u0016\u0014h/[2f\u0003\u0011q\u0017-\\3\u0011\u0005\tZcBA\u0012*!\t!s%D\u0001&\u0015\t1#$\u0001\u0004=e>|GO\u0010\u0006\u0002Q\u0005)1oY1mC&\u0011!fJ\u0001\u0007!J,G-\u001a4\n\u00051j#AB*ue&twM\u0003\u0002+O\u00051A(\u001b8jiz\"\"\u0001M\u0019\u0011\u0005u\u0001\u0001\"\u0002\u0011\u0003\u0001\u0004\tC#\u0001\u0019\u0002\u001b\u0015D\b/\u001b:j]\u001e4\u0015\u000e\\3t+\u0005)\u0004\u0003\u0002\u001c@C\u0005j\u0011a\u000e\u0006\u0003qe\nQaY1dQ\u0016T!AO\u001e\u0002\r\r|W.\\8o\u0015\taT(\u0001\u0004h_><G.\u001a\u0006\u0002}\u0005\u00191m\\7\n\u0005\u0001;$!B\"bG\",\u0017!E3ya&\u0014\u0018N\\4GS2,7o\u0018\u0013fcR\u00111i\u0012\t\u0003\t\u0016k\u0011aJ\u0005\u0003\r\u001e\u0012A!\u00168ji\"9\u0001*BA\u0001\u0002\u0004)\u0014a\u0001=%c\u0005qQ\r\u001f9je&twMR5mKN\u0004\u0013\u0001E2mK\u0006tW\u000f]*dQ\u0016$W\u000f\\3s+\u0005a\u0005CA'U\u001b\u0005q%BA(Q\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003#J\u000bA!\u001e;jY*\t1+\u0001\u0003kCZ\f\u0017BA+O\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u001be\u0016l\u0017-\u001b8fI\u0016C\b/\u001b:j]\u001e4\u0015\u000e\\3t\u0007>,h\u000e\u001e\u000b\u00021B\u0011A)W\u0005\u00035\u001e\u0012A\u0001T8oO\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0005\rk\u0006\"\u00020\n\u0001\u0004y\u0016\u0001B2p]\u001a\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u000b\u0002\r\r|gNZ5h\u0013\t!\u0017M\u0001\u0006LsV,(-[\"p]\u001a\fAa\u001d;paR\t1)A\bdY\u0016\fg.\u001e9GS2,\u0007+\u0019;i)\t\u0019\u0015\u000eC\u0003k\u0017\u0001\u0007\u0011%A\u0004qCRD7\u000b\u001e:\u0002'\u0005$G\rU1uQR{W\t\u001f9je\u0006$\u0018n\u001c8\u0015\u0005\rk\u0007\"\u00028\r\u0001\u0004y\u0017\u0001\u00029bi\"\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\t\u0019LG.\u001a\u0006\u0003iJ\u000b1A\\5p\u0013\t1\u0018O\u0001\u0003QCRD\u0017a\u0004+f[B4\u0015\u000e\\3TKJ4\u0018nY3\u0011\u0005uq1C\u0001\b{!\t!50\u0003\u0002}O\t1\u0011I\\=SK\u001a$\u0012\u0001_\u0001\u0010i\u0016l\u0007OR5mK\u000e{WO\u001c;feV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001(\u0002\r\u0005$x.\\5d\u0013\u0011\tY!!\u0002\u0003\u0015\u0005#x.\\5d\u0019>tw\r")
public class TempFileService
extends AbstractService {
    private ScheduledExecutorService cleanupScheduler;
    private String name;
    private Cache<String, String> expiringFiles;
    private volatile boolean bitmap$0;

    private final Cache<String, String> expiringFiles() {
        return this.expiringFiles;
    }

    private final void expiringFiles_$eq(Cache<String, String> x$1) {
        this.expiringFiles = x$1;
    }

    private ScheduledExecutorService cleanupScheduler$lzycompute() {
        TempFileService tempFileService = this;
        synchronized (tempFileService) {
            if (!this.bitmap$0) {
                this.cleanupScheduler = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor(new StringBuilder(18).append(this.name).append("-cleanup-scheduler").toString(), ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor$default$2());
                this.bitmap$0 = true;
            }
        }
        this.name = null;
        return this.cleanupScheduler;
    }

    private ScheduledExecutorService cleanupScheduler() {
        if (!this.bitmap$0) {
            return this.cleanupScheduler$lzycompute();
        }
        return this.cleanupScheduler;
    }

    public long remainedExpiringFilesCount() {
        return this.expiringFiles().size();
    }

    @Override
    public void initialize(KyuubiConf conf) {
        super.initialize(conf);
        long expireTimeInMs = BoxesRunTime.unboxToLong(conf.get(KyuubiConf$.MODULE$.SERVER_TEMP_FILE_EXPIRE_TIME()));
        Option maxCountOpt = (Option)conf.get(KyuubiConf$.MODULE$.SERVER_TEMP_FILE_EXPIRE_MAX_COUNT());
        CacheBuilder builder = CacheBuilder.newBuilder().expireAfterWrite(expireTimeInMs, TimeUnit.MILLISECONDS).removalListener(notification -> {
            String pathStr = (String)notification.getValue();
            this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Remove expired temp file: ").append(pathStr).toString());
            this.cleanupFilePath(pathStr);
        });
        maxCountOpt.foreach((Function1<Object, CacheBuilder> & Serializable & scala.Serializable)x$1 -> builder.maximumSize((long)BoxesRunTime.unboxToInt(x$1)));
        this.expiringFiles_$eq((Cache<String, String>)builder.build());
        this.cleanupScheduler().scheduleAtFixedRate(() -> this.expiringFiles().cleanUp(), 0L, Math.max(expireTimeInMs / 10L, 100L), TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.expiringFiles().asMap().values().forEach(pathStr -> this.cleanupFilePath((String)pathStr));
        super.stop();
    }

    private void cleanupFilePath(String pathStr) {
        try {
            Path path = Paths.get(pathStr, new String[0]);
            TempFileCleanupUtils$.MODULE$.cancelDeleteOnExit(path);
            Utils$.MODULE$.deleteDirectoryRecursively(path.toFile(), Utils$.MODULE$.deleteDirectoryRecursively$default$2());
        }
        catch (Throwable e) {
            this.error((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Failed to delete file ").append(pathStr).toString(), e);
        }
    }

    public void addPathToExpiration(Path path) {
        Predef$.MODULE$.require(path != null);
        this.expiringFiles().put((Object)new StringBuilder(1).append(TempFileService$.MODULE$.org$apache$kyuubi$service$TempFileService$$tempFileCounter().incrementAndGet()).append("-").append(System.currentTimeMillis()).toString(), (Object)((Object)path).toString());
        TempFileCleanupUtils$.MODULE$.deleteOnExit(path);
    }

    public TempFileService(String name) {
        this.name = name;
        super(name);
    }

    public TempFileService() {
        this(TempFileService.class.getSimpleName());
    }
}

