/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.SocketAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.LoggerFields;
import org.apache.logging.log4j.core.layout.Rfc5424Layout;
import org.apache.logging.log4j.core.layout.SyslogLayout;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.net.Facility;
import org.apache.logging.log4j.core.net.Protocol;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="Syslog")
public class SyslogAppender
extends SocketAppender {
    protected static final String RFC5424 = "RFC5424";

    protected SyslogAppender(String name, Layout layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, AbstractSocketManager manager, Advertiser advertiser) {
        super(name, layout, filter, manager, ignoreExceptions, immediateFlush, advertiser);
    }

    @PluginFactory
    public static <B extends Builder<B>> B newSyslogAppenderBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends SocketAppender.AbstractBuilder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<SocketAppender> {
        @PluginBuilderAttribute(value="facility")
        private @PluginBuilderAttribute(value="facility") Facility facility = Facility.LOCAL0;
        @PluginBuilderAttribute(value="id")
        private @PluginBuilderAttribute(value="id") String id;
        @PluginBuilderAttribute(value="enterpriseNumber")
        private @PluginBuilderAttribute(value="enterpriseNumber") String enterpriseNumber = String.valueOf(32473);
        @PluginBuilderAttribute(value="includeMdc")
        private @PluginBuilderAttribute(value="includeMdc") boolean includeMdc = true;
        @PluginBuilderAttribute(value="mdcId")
        private @PluginBuilderAttribute(value="mdcId") String mdcId;
        @PluginBuilderAttribute(value="mdcPrefix")
        private @PluginBuilderAttribute(value="mdcPrefix") String mdcPrefix;
        @PluginBuilderAttribute(value="eventPrefix")
        private @PluginBuilderAttribute(value="eventPrefix") String eventPrefix;
        @PluginBuilderAttribute(value="newLine")
        private @PluginBuilderAttribute(value="newLine") boolean newLine;
        @PluginBuilderAttribute(value="newLineEscape")
        private @PluginBuilderAttribute(value="newLineEscape") String escapeNL;
        @PluginBuilderAttribute(value="appName")
        private @PluginBuilderAttribute(value="appName") String appName;
        @PluginBuilderAttribute(value="messageId")
        private @PluginBuilderAttribute(value="messageId") String msgId;
        @PluginBuilderAttribute(value="mdcExcludes")
        private @PluginBuilderAttribute(value="mdcExcludes") String excludes;
        @PluginBuilderAttribute(value="mdcIncludes")
        private @PluginBuilderAttribute(value="mdcIncludes") String includes;
        @PluginBuilderAttribute(value="mdcRequired")
        private @PluginBuilderAttribute(value="mdcRequired") String required;
        @PluginBuilderAttribute(value="format")
        private @PluginBuilderAttribute(value="format") String format;
        @PluginBuilderAttribute(value="charset")
        private @PluginBuilderAttribute(value="charset") Charset charsetName = StandardCharsets.UTF_8;
        @PluginBuilderAttribute(value="exceptionPattern")
        private @PluginBuilderAttribute(value="exceptionPattern") String exceptionPattern;
        @PluginElement(value="LoggerFields")
        private @PluginElement(value="LoggerFields") LoggerFields[] loggerFields;

        public SyslogAppender build() {
            String name;
            Protocol protocol = this.getProtocol();
            SslConfiguration sslConfiguration = this.getSslConfiguration();
            boolean useTlsMessageFormat = sslConfiguration != null || protocol == Protocol.SSL;
            Configuration configuration = this.getConfiguration();
            Layout layout = this.getLayout();
            if (layout == null) {
                Layout layout2 = layout = SyslogAppender.RFC5424.equalsIgnoreCase(this.format) ? ((Rfc5424Layout.Rfc5424LayoutBuilder)new Rfc5424Layout.Rfc5424LayoutBuilder().setConfig(configuration).setFacility(this.facility).setId(this.id).setEin(this.enterpriseNumber).setIncludeMDC(this.includeMdc).setMdcId(this.mdcId).setMdcPrefix(this.mdcPrefix).setEventPrefix(this.eventPrefix).setIncludeNL(this.newLine).setEscapeNL(this.escapeNL).setAppName(this.appName).setMessageId(this.msgId).setExcludes(this.excludes).setIncludes(this.includes).setRequired(this.required).setExceptionPattern(this.exceptionPattern).setUseTLSMessageFormat(useTlsMessageFormat).setLoggerFields(this.loggerFields).setConfiguration(configuration)).build() : ((SyslogLayout.Builder)((AbstractLayout.Builder)((SyslogLayout.Builder)((SyslogLayout.Builder)((SyslogLayout.Builder)((AbstractLayout.Builder)SyslogLayout.newBuilder()).setConfiguration(configuration)).setFacility(this.facility)).setIncludeNewLine(this.newLine)).setEscapeNL(this.escapeNL)).setCharset(this.charsetName)).build();
            }
            if ((name = this.getName()) == null) {
                LOGGER.error("No name provided for SyslogAppender");
                return null;
            }
            AbstractSocketManager manager = SocketAppender.createSocketManager(name, protocol, this.getHost(), this.getPort(), this.getConnectTimeoutMillis(), sslConfiguration, this.getReconnectDelayMillis(), this.getImmediateFail(), layout, Constants.ENCODER_BYTE_BUFFER_SIZE, null);
            return new SyslogAppender(name, layout, this.getFilter(), this.isIgnoreExceptions(), this.isImmediateFlush(), manager, this.getAdvertise() ? configuration.getAdvertiser() : null);
        }

        public Facility getFacility() {
            return this.facility;
        }

        public String getId() {
            return this.id;
        }

        public String getEnterpriseNumber() {
            return this.enterpriseNumber;
        }

        public boolean isIncludeMdc() {
            return this.includeMdc;
        }

        public String getMdcId() {
            return this.mdcId;
        }

        public String getMdcPrefix() {
            return this.mdcPrefix;
        }

        public String getEventPrefix() {
            return this.eventPrefix;
        }

        public boolean isNewLine() {
            return this.newLine;
        }

        public String getEscapeNL() {
            return this.escapeNL;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getMsgId() {
            return this.msgId;
        }

        public String getExcludes() {
            return this.excludes;
        }

        public String getIncludes() {
            return this.includes;
        }

        public String getRequired() {
            return this.required;
        }

        public String getFormat() {
            return this.format;
        }

        public Charset getCharsetName() {
            return this.charsetName;
        }

        public String getExceptionPattern() {
            return this.exceptionPattern;
        }

        public LoggerFields[] getLoggerFields() {
            return this.loggerFields;
        }

        public B setFacility(Facility facility) {
            this.facility = facility;
            return (B)((Builder)this.asBuilder());
        }

        public B setId(String id) {
            this.id = id;
            return (B)((Builder)this.asBuilder());
        }

        public B setEnterpriseNumber(String enterpriseNumber) {
            this.enterpriseNumber = enterpriseNumber;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludeMdc(boolean includeMdc) {
            this.includeMdc = includeMdc;
            return (B)((Builder)this.asBuilder());
        }

        public B setMdcId(String mdcId) {
            this.mdcId = mdcId;
            return (B)((Builder)this.asBuilder());
        }

        public B setMdcPrefix(String mdcPrefix) {
            this.mdcPrefix = mdcPrefix;
            return (B)((Builder)this.asBuilder());
        }

        public B setEventPrefix(String eventPrefix) {
            this.eventPrefix = eventPrefix;
            return (B)((Builder)this.asBuilder());
        }

        public B setNewLine(boolean newLine) {
            this.newLine = newLine;
            return (B)((Builder)this.asBuilder());
        }

        public B setEscapeNL(String escapeNL) {
            this.escapeNL = escapeNL;
            return (B)((Builder)this.asBuilder());
        }

        public B setAppName(String appName) {
            this.appName = appName;
            return (B)((Builder)this.asBuilder());
        }

        public B setMsgId(String msgId) {
            this.msgId = msgId;
            return (B)((Builder)this.asBuilder());
        }

        public B setExcludes(String excludes) {
            this.excludes = excludes;
            return (B)((Builder)this.asBuilder());
        }

        public B setIncludes(String includes) {
            this.includes = includes;
            return (B)((Builder)this.asBuilder());
        }

        public B setRequired(String required) {
            this.required = required;
            return (B)((Builder)this.asBuilder());
        }

        public B setFormat(String format) {
            this.format = format;
            return (B)((Builder)this.asBuilder());
        }

        public B setCharsetName(Charset charset) {
            this.charsetName = charset;
            return (B)((Builder)this.asBuilder());
        }

        public B setExceptionPattern(String exceptionPattern) {
            this.exceptionPattern = exceptionPattern;
            return (B)((Builder)this.asBuilder());
        }

        public B setLoggerFields(LoggerFields[] loggerFields) {
            this.loggerFields = loggerFields;
            return (B)((Builder)this.asBuilder());
        }
    }
}

